/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.Parcela;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.util.Collection;

public class MicCapturaValorParcela {
    public static final String FILLED = "FILLED";
    public static final String SUCESS = "SUCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String VALUE_NOT_VALID = "VALUE_NOT_VALID";
    public static final String VALUE_NOT_VALID_AC = "VALUE_NOT_VALID_AC";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (!Contexto.getContexto().getSaidaApiTefC().isParcela()) {
            return UNECESSARY;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isParcelasCtrl()) {
            Collection<Parcela> parcelas = Contexto.getContexto().getEntradaIntegracao().getParcelas();
            if (parcelas != null && !parcelas.isEmpty()) {
                Parcela parcela = parcelas.iterator().next();
                if (this.isValidaValorParcela(Contexto.getContexto().getEntradaApiTefC().getValorTransacao(), parcela.getValor())) {
                    Contexto.getContexto().getEntradaApiTefC().setValorEntrada(Contexto.getContexto().getEntradaIntegracao().getValorParcela());
                    return SUCESS;
                }
            }
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CAPVAL1PAR_VALOR_INVALIDO, inter.getMessage("CAPVALPAR_VALOR_INVALIDO")));
            return VALUE_NOT_VALID_AC;
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPVALPAR_VALOR_ENTRADA"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_PARCELA, false);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            digitos = "000";
        }
        BigDecimal valor = new BigDecimal(digitos);
        valor = valor.movePointLeft(2);
        if (!this.isValidaValorParcela(Contexto.getContexto().getEntradaApiTefC().getValorTransacao(), valor)) {
            if (this.exibeMensagem(perifericos, inter.getMessage("CAPVALPAR_VALOR_INVALIDO")).equals("ENTRA")) {
                return VALUE_NOT_VALID;
            }
            return USERCANCEL;
        }
        Contexto.getContexto().getEntradaApiTefC().setValorParcela(valor);
        return SUCESS;
    }

    private String exibeMensagem(ControladorPerifericos perifericos, String messagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(messagem);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    public boolean isValidaValorParcela(BigDecimal valorTransacao, BigDecimal valorParcela) {
        BigDecimal valorCalculado;
        BigDecimal valorEntrada = Contexto.getContexto().getEntradaApiTefC().getValorEntrada();
        int numeroParcela = Contexto.getContexto().getEntradaApiTefC().getNumeroParcelas();
        if (valorEntrada == null) {
            valorEntrada = new BigDecimal(0);
        }
        return (valorCalculado = valorParcela.multiply(new BigDecimal(numeroParcela)).add(valorEntrada)).compareTo(valorTransacao) != 1;
    }
}

