/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.SubField;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.entrada.ICargaTabelasPinpad;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.controller.ControladorAIDs;
import com.csi.ctfclient.operacoes.model.controller.ControladorAIDsGetCard;
import com.csi.ctfclient.operacoes.model.controller.ControladorMultiEC;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.ConstantesEMV;
import com.csi.ctfclient.tools.devices.emv.DadosGetInfoRedeEMV;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MicCargaTabelaPinpad
implements ConstantesEMV {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public int numRegistros(String registros) {
        int tam = 0;
        int numRegistros = 0;
        if (registros == null) {
            return 0;
        }
        while (tam < registros.length()) {
            String strTam = registros.substring(tam, tam + 3);
            int offset = Integer.parseInt(strTam);
            tam = offset == 0 ? (tam += 3) : (tam += offset);
            ++numRegistros;
        }
        return numRegistros;
    }

    public String execute(ICargaTabelasPinpad dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        ControladorPerifericos perifericos = dados.getPerifericos();
        try {
            ILeitorCartaoHandler leitorCartao = perifericos.getLeitorCartao();
            CMOSPinPad cmos = CMOSPinPad.getInstance();
            SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
            int redeAdquirente = saida != null && saida.getTipoBibliotecaPinpad() == 2 ? leitorCartao.getRedeAdquirente() : 0;
            boolean multiEC = config.isMultiEC();
            IdentTerminal identTerminal = multiEC ? ControladorMultiEC.criarTerminalComumMultiEC(config.getCodigoGrupoMultiEC()) : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
            String timeStamp = cmos.getTimeStamp(redeAdquirente);
            ArrayList<String> redesPPNoApplication = new ArrayList<String>();
            ControladorAIDs controladorAIDs = new ControladorAIDs(redesPPNoApplication);
            boolean mobile = config.isIntegracaoAndroid();
            if (mobile) {
                for (Map.Entry<String, List<String>> entry : dados.getConteudoTabelas().entrySet()) {
                    for (String tabela : entry.getValue()) {
                        DadosGetInfoRedeEMV dadosInfoEMV;
                        String rede = ControladorAIDs.getRedeTabela(tabela);
                        if (rede == null || redesPPNoApplication.contains(rede) || (dadosInfoEMV = perifericos.getPin().getInfoRedeEMV(Integer.parseInt(rede))) != null && dadosInfoEMV.getRetorno() != 22) continue;
                        redesPPNoApplication.add(rede);
                    }
                }
                logger.info("redesPPNoApplication: " + redesPPNoApplication);
            }
            DecimalFormat format2Zeros = new DecimalFormat("00");
            int retry = 0;
            boolean ocorreuErro = false;
            do {
                int indice = 1;
                int retorno = leitorCartao.iniciaCargaTabelas(timeStamp);
                if (retorno == 20 || retorno == 0) {
                    Integer numberOfTables = this.getNumberOfTables(dados.getConteudoTabelas());
                    block7: for (Map.Entry<String, List<String>> entry : dados.getConteudoTabelas().entrySet()) {
                        for (String tabela : entry.getValue()) {
                            if (ocorreuErro) continue block7;
                            int numRegistros = this.numRegistros(tabela);
                            if (numRegistros == 0) continue;
                            logger.info("Dados tabela: 01" + tabela);
                            controladorAIDs.addLinhaCargaTabelas(tabela, this.isPriorityTable(entry.getKey()));
                            perifericos.imprimeDisplay(new LayoutDisplay(inter.getMessage("ENV2M_ATUALIZANDO") + " (" + format2Zeros.format(indice) + "/" + numberOfTables + ")"));
                            ++indice;
                            ocorreuErro = leitorCartao.executaCargaTabelas("01" + tabela) != 0;
                        }
                    }
                    ocorreuErro = leitorCartao.finalizaCargaTabelas() != 0;
                    continue;
                }
                ocorreuErro = true;
            } while (++retry <= 3 && ocorreuErro);
            if (!ocorreuErro) {
                cmos.habilitaCargaTabelas(redeAdquirente);
                logger.info("Persistindo AIDs que ser\u00e3o utilizados na GetCard...");
                try {
                    ControladorAIDsGetCard controladorAIDsGetCard = ControladorAIDsGetCard.getInstance(identTerminal);
                    controladorAIDsGetCard.saveMapAid(controladorAIDs.getMapAIDs());
                    leitorCartao.setSolicitaCargaTabelas(LeitorCartao.CARGA_TABELA_OK);
                    leitorCartao.setTableVersion(timeStamp);
                    if (config.isIntegracaoAndroid()) {
                        leitorCartao.desabilita();
                    }
                    logger.info("AIDs persistidos com sucesso");
                    logger.info("******************************************************************");
                    logger.info("******** CARGA DE TABELA NO PIN EFETUADA COM SUCESSO *************");
                    logger.info("******************************************************************");
                }
                catch (Exception e) {
                    logger.warn("Problema ao persistir os AIDs para leitura na GetCard. Erro: ".concat(e.getMessage()));
                }
            } else {
                logger.error("******************************************************************");
                logger.error("*************** ERRO NA CARGA DE TABELA NO PIN *******************");
                logger.error("******************************************************************");
            }
            logger.info("For\u00e7ando uma nova gera\u00e7\u00e3o da lista de AID");
            Contexto.getContexto().setListAID(null);
            return SUCESS;
        }
        catch (Exception e) {
            logger.error("Erro durante a carga de tabelas do pinpad: " + e.getMessage());
            if (Contexto.getContexto().getErroIntegracao() == null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TENTE_NOVAMENTE, "TENTE NOVAMENTE"));
            }
            return ERRO;
        }
    }

    private Integer getNumberOfTables(Map<String, List<String>> conteudoTabelas) {
        Integer numberOfTables = 0;
        for (Map.Entry<String, List<String>> entry : conteudoTabelas.entrySet()) {
            numberOfTables = numberOfTables + entry.getValue().size();
        }
        return numberOfTables;
    }

    private boolean isPriorityTable(String key) {
        return SubField.TAB1_PIN.getCode().equals(key);
    }
}

