/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.operacoes.model.controller.ControladorMultiEC;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import java.util.Objects;

public class MicCheckQrCodeParam
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        ConfCTFClient config = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        boolean multiEC = config.isMultiEC();
        try {
            ControladorInicioDia startDayControl;
            DadosInicioDia startDayData;
            IdentTerminal identTerminal;
            if (multiEC) {
                ControladorMultiEC controladorMultiEC = ControladorMultiEC.getInstance();
                try {
                    EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
                    identTerminal = controladorMultiEC.determinarTerminal(entradaIntegracao.getIdentificadorMultiEC());
                }
                catch (Exception e) {
                    this.logger.error("Falha ao obter identifica\u00e7\u00e3o do terminal: " + e.getMessage());
                    return ERROR;
                }
            } else {
                identTerminal = new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
            }
            if (!(startDayData = (startDayControl = ControladorInicioDia.getInstance()).getDadosInicioDia(identTerminal)).isQrCode()) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.OPERACAO_NAO_PERMITIDA, "As transa\u00e7\u00f5es de QR Code n\u00e3o est\u00e3o habilitadas para esse EC!"));
                Contexto.getContexto().setErrorCode(1);
                return ERROR;
            }
        }
        catch (Exception e) {
            this.logger.warn("Falha ao obter dados do dia: " + e.getMessage());
            return ERROR;
        }
        if (null == this.tryGetPin()) {
            this.logger.error("N\u00e3o \u00e9 poss\u00edvel fazer transa\u00e7\u00f5es QR Code sem pinpad!");
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CONECTE_PIN_PAD, "999 - ERRO CONECTE PINPAD"));
            return ERROR;
        }
        return SUCCESS;
    }
}

