/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ConfClienteServico;
import com.csi.ctfclient.config.ConfPOSTef;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessCargaTabelaForcadaTest;
import com.csi.ctfclient.operacoes.action.ProcessInicioDia;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicConfigureIPCTFServer;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.postef.POSTef;
import com.csi.ctfclient.tools.devices.postef.servico.POSTefServico;

public class MicConfigurarTerminal {
    private static final String OPCAO_INICIALIZACAO = "INICIALIZACAO";
    private static final String OPCAO_TERMINAL = "TERMINAL";
    private static final String OPCAO_CTF_SERVER = "CTF-SERVER";
    private static final String OPCAO_PINPAD = "PINPAD";
    private static final String OPCAO_CARGA_TABELA = "CARGA DE TABELAS";
    private static final String OPCAO_CLIENT_SERVICO = "CLIENTE SERVICO";
    private static final String OPCAO_POS_MOVEL = "POS-MOVEL";
    private static final String OPCAO_SAIR = "SAIR";
    public static String OK = "OK";
    public static String ERRO = "ERRO";
    public static String CANCELADO_USUARIO = "CANCELADO_USUARIO";
    public static String CONFIGURE_TERMINAL = "CONFIGURE_TERMINAL";
    public static String CONFIGURE_PINPAD = "CONFIGURE_PINPAD";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        ControladorPerifericos perifericos = dados.getPerifericos();
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        ConfClienteServico confClienteServico = confCTFClient.getConfClienteServico();
        boolean sair = false;
        while (!sair) {
            int item = 1;
            LayoutMenu layoutMenu = new LayoutMenu("CONFIGURACAO", true);
            if (!confCTFClient.isMultiEC()) {
                layoutMenu.addItem(new ItemMenu(OPCAO_INICIALIZACAO, String.valueOf(item++)));
            }
            if (!confCTFClient.isSuporteHttps()) {
                layoutMenu.addItem(new ItemMenu(OPCAO_TERMINAL, String.valueOf(item++)));
                layoutMenu.addItem(new ItemMenu(OPCAO_CTF_SERVER, String.valueOf(item++)));
            }
            layoutMenu.addItem(new ItemMenu(OPCAO_PINPAD, String.valueOf(item++)));
            if (!confCTFClient.isMultiEC()) {
                layoutMenu.addItem(new ItemMenu(OPCAO_CARGA_TABELA, String.valueOf(item++)));
            }
            if (confClienteServico != null && confClienteServico.getHost() != null) {
                layoutMenu.addItem(new ItemMenu(OPCAO_POS_MOVEL, String.valueOf(item++)));
                layoutMenu.addItem(new ItemMenu(OPCAO_CLIENT_SERVICO, String.valueOf(item++)));
            }
            layoutMenu.addItem(new ItemMenu(OPCAO_SAIR, String.valueOf(item++)));
            int opcao = perifericos.imprimeMenu(layoutMenu);
            if (opcao == -1) {
                if (perifericos.exibeMenuCancelamento() != 1) continue;
                sair = true;
                continue;
            }
            ItemMenu itemMenu = layoutMenu.getItens().get(opcao - 1);
            switch (itemMenu.getTexto()) {
                case "INICIALIZACAO": {
                    this.inicioDia(dados);
                    break;
                }
                case "TERMINAL": {
                    Contexto.getContexto().setManualConfigOverride(true);
                    return CONFIGURE_TERMINAL;
                }
                case "CTF-SERVER": {
                    this.configurarCTFServer(dados);
                    break;
                }
                case "PINPAD": {
                    Contexto.getContexto().setManualConfigOverride(true);
                    return CONFIGURE_PINPAD;
                }
                case "CARGA DE TABELAS": {
                    this.cargaTabelasPinpad(dados);
                    break;
                }
                case "POS-MOVEL": {
                    this.configurarPOSMovel(dados);
                    break;
                }
                case "CLIENTE SERVICO": {
                    this.configurarClientService(dados);
                    break;
                }
                case "SAIR": {
                    sair = true;
                    break;
                }
            }
        }
        SaidaApiTefC saidaApiTefC = new SaidaApiTefC();
        saidaApiTefC.setRetorno(0);
        Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
        Contexto.getContexto().setErroIntegracao(null);
        dados.setErro(null);
        return OK;
    }

    private void configurarCTFServer(Process dados) throws ExcecaoNaoLocal {
        Contexto.getContexto().setManualConfigOverride(true);
        MicConfigureIPCTFServer micConfigureIPCTFServer = new MicConfigureIPCTFServer();
        micConfigureIPCTFServer.execute(dados);
    }

    private void inicioDia(Process dados) throws ExcecaoNaoLocal {
        ControladorPerifericos perifericos = dados.getPerifericos();
        ProcessInicioDia processInicioDia = new ProcessInicioDia(dados.getProcessConstructorArguments(), null);
        processInicioDia.setParent(dados);
        ProcessManager.getInstance().subProcess(processInicioDia.getIdProcess(), processInicioDia);
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (saidaApiTefC != null) {
            if (saidaApiTefC.getRetorno() == 0) {
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha("CTFCLIENT INICIALIZADO"));
                layoutDisplay.addLinha(new Linha("COM SUCESSO"));
                perifericos.confirmaDado(layoutDisplay);
            } else {
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha("NAO FOI POSSIVEL REALIZAR"));
                layoutDisplay.addLinha(new Linha("A INICIALIZACAO DO CTFCLIENT"));
                layoutDisplay.addLinha(new Linha("DETALHE:", 0, 2));
                layoutDisplay.addLinha(new Linha("RETORNO: " + saidaApiTefC.getRetorno()));
                if (saidaApiTefC.getCodigoErro() != null) {
                    layoutDisplay.addLinha(new Linha("ERRO: " + saidaApiTefC.getCodigoErro()));
                }
                perifericos.confirmaDado(layoutDisplay);
            }
        }
    }

    private void cargaTabelasPinpad(Process dados) throws ExcecaoNaoLocal {
        ControladorPerifericos perifericos = dados.getPerifericos();
        ProcessCargaTabelaForcadaTest processCargaTabela = new ProcessCargaTabelaForcadaTest(dados.getProcessConstructorArguments());
        processCargaTabela.setParent(dados);
        ProcessManager.getInstance().subProcess(processCargaTabela.getIdProcess(), processCargaTabela);
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        CodigoErroIntegracao erroIntegracao = Contexto.getContexto().getErroIntegracao();
        if (saidaApiTefC != null && saidaApiTefC.getRetorno() != 0) {
            LayoutDisplay layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("NAO FOI POSSIVEL REALIZAR"));
            layoutDisplay.addLinha(new Linha("A CARGA DE TABELAS DO PINPAD"));
            layoutDisplay.addLinha(new Linha("DETALHE:", 0, 2));
            layoutDisplay.addLinha(new Linha("RETORNO: " + saidaApiTefC.getRetorno()));
            if (saidaApiTefC.getCodigoErro() != null) {
                layoutDisplay.addLinha(new Linha("ERRO: " + saidaApiTefC.getCodigoErro()));
            }
            perifericos.confirmaDado(layoutDisplay);
        } else if (erroIntegracao != null) {
            LayoutDisplay layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("NAO FOI POSSIVEL REALIZAR"));
            layoutDisplay.addLinha(new Linha("A CARGA DE TABELAS DO PINPAD"));
            layoutDisplay.addLinha(new Linha("DETALHE:", 0, 2));
            layoutDisplay.addLinha(new Linha("RETORNO: " + erroIntegracao.getCodigo().getCode()));
            layoutDisplay.addLinha(new Linha("VERIFIQUE SE O PINPAD ESTA"));
            layoutDisplay.addLinha(new Linha("CONECTADO E REALIZE A CONFIGURACAO"));
            perifericos.confirmaDado(layoutDisplay);
        } else {
            LayoutDisplay layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("CARGA DE TABELAS DO PINPAD"));
            layoutDisplay.addLinha(new Linha("REALIZADA COM SUCESSO"));
            perifericos.confirmaDado(layoutDisplay);
        }
    }

    private void configurarClientService(Process dados) throws ExcecaoNaoLocal {
        ControladorPerifericos perifericos = dados.getPerifericos();
        boolean sair = false;
        while (!sair) {
            LayoutDisplay layoutDisplay;
            boolean sairMenu;
            ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
            ConfClienteServico confClienteServico = confCTFClient.getConfClienteServico();
            String statusClientService = confClienteServico.isHabilitado() ? "DESABILITAR" : "HABILITAR";
            LayoutMenu layoutMenu = new LayoutMenu("CONFIGURACAO -> CLIENTE SERVICO", true);
            layoutMenu.addItem(new ItemMenu(statusClientService, "1"));
            layoutMenu.addItem(new ItemMenu("CODIGO DO PDV", "2"));
            int opcao = perifericos.imprimeMenu(layoutMenu);
            EventoTeclado evTeclado = null;
            if (opcao == -1) {
                sair = true;
                continue;
            }
            POSTef.init(POSTefServico.class);
            POSTef<?> posMovel = POSTef.getInstance();
            if (opcao == 1) {
                sairMenu = false;
                Boolean habilitaClientService = null;
                while (!sairMenu) {
                    layoutMenu = new LayoutMenu(statusClientService + " CLIENTE SERVICO?", true);
                    layoutMenu.addItem(new ItemMenu("SIM", "1"));
                    layoutMenu.addItem(new ItemMenu("NAO", "2"));
                    opcao = perifericos.imprimeMenu(layoutMenu);
                    if (opcao == -1) {
                        sairMenu = true;
                    } else if (opcao == 1) {
                        habilitaClientService = confClienteServico.isHabilitado() ? Boolean.valueOf(false) : Boolean.valueOf(true);
                    } else if (opcao == 2) {
                        habilitaClientService = confClienteServico.isHabilitado() ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (confClienteServico == null || habilitaClientService == null) continue;
                    confClienteServico.setHabilitado(habilitaClientService);
                    sairMenu = true;
                }
                if (!sairMenu || habilitaClientService == null) continue;
                LayoutDisplay layoutDisplay2 = new LayoutDisplay();
                layoutDisplay2 = new LayoutDisplay();
                layoutDisplay2.addLinha(new Linha(OPCAO_CLIENT_SERVICO));
                if (habilitaClientService.booleanValue()) {
                    posMovel.conecta();
                    layoutDisplay2.addLinha(new Linha("HABILITADO"));
                } else {
                    layoutDisplay2.addLinha(new Linha("DESABILITADO"));
                    posMovel.desconecta();
                }
                ControladorConfCTFClient.getInstance().save(confCTFClient);
                perifericos.confirmaDado(layoutDisplay2);
                continue;
            }
            if (opcao != 2) continue;
            sairMenu = false;
            while (!sairMenu) {
                layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha("CONFIGURACAO -> CLIENTE SERVICO"));
                layoutDisplay.addLinha(new Linha("CODIGO PDV:"));
                evTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CODIGO_PDV, 0, true, 12, true, confClienteServico.getCodigoPdv());
                if (evTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                    return;
                }
                String pdv = evTeclado.getStringLida().trim();
                if (pdv == null || "".equals(pdv)) {
                    layoutDisplay = new LayoutDisplay("CODIGO DO PDV INVALIDO");
                    perifericos.confirmaDado(layoutDisplay);
                    continue;
                }
                if (confClienteServico != null) {
                    confClienteServico.setCodigoPdv(pdv);
                }
                sairMenu = true;
            }
            if (!sairMenu) continue;
            ControladorConfCTFClient.getInstance().save(confCTFClient);
            layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("CODIGO DO PDV"));
            layoutDisplay.addLinha(new Linha("CONFIGURADO"));
            if (posMovel.isInicializado()) {
                layoutDisplay.addLinha(new Linha("NECESSARIO REINICIAR", 0, 1));
                layoutDisplay.addLinha(new Linha(OPCAO_CLIENT_SERVICO));
            } else {
                layoutDisplay.addLinha(new Linha("NECESSARIO INICIAR", 0, 1));
                layoutDisplay.addLinha(new Linha(OPCAO_CLIENT_SERVICO));
            }
            perifericos.confirmaDado(layoutDisplay);
        }
    }

    private void configurarPOSMovel(Process dados) throws ExcecaoNaoLocal {
        ControladorPerifericos perifericos = dados.getPerifericos();
        boolean sair = false;
        while (!sair) {
            LayoutDisplay layoutDisplay;
            ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
            ConfPOSTef confPOSTef = confCTFClient.getConfPOSTef();
            String statusPOSMovel = confCTFClient.getConfPOSTef().isHabilitado() ? "DESABILITAR" : "HABILITAR";
            LayoutMenu layoutMenu = new LayoutMenu("CONFIGURACAO -> POS-MOVEL", true);
            layoutMenu.addItem(new ItemMenu(statusPOSMovel, "1"));
            layoutMenu.addItem(new ItemMenu("COD. TERMINAL", "2"));
            int opcao = perifericos.imprimeMenu(layoutMenu);
            EventoTeclado evTeclado = null;
            if (opcao == -1) {
                sair = true;
                continue;
            }
            POSTef.init(POSTefServico.class);
            POSTef<?> posMovel = POSTef.getInstance();
            if (opcao == 1) {
                Boolean habilitaPosMovel = null;
                boolean sairMenu = false;
                while (!sairMenu) {
                    layoutMenu = new LayoutMenu(statusPOSMovel + " POS-MOVEL?", true);
                    layoutMenu.addItem(new ItemMenu("SIM", "1"));
                    layoutMenu.addItem(new ItemMenu("NAO", "2"));
                    opcao = perifericos.imprimeMenu(layoutMenu);
                    if (opcao == -1) {
                        sair = true;
                    } else if (opcao == 1) {
                        habilitaPosMovel = confPOSTef.isHabilitado() ? Boolean.valueOf(false) : Boolean.valueOf(true);
                    } else if (opcao == 2) {
                        habilitaPosMovel = confPOSTef.isHabilitado() ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (confPOSTef == null || habilitaPosMovel == null) continue;
                    confPOSTef.setHabilitado(habilitaPosMovel);
                    sairMenu = true;
                }
                if (!sairMenu || habilitaPosMovel == null) continue;
                layoutDisplay = new LayoutDisplay();
                layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha(OPCAO_POS_MOVEL));
                if (habilitaPosMovel.booleanValue()) {
                    layoutDisplay.addLinha(new Linha("HABILITADO"));
                } else {
                    layoutDisplay.addLinha(new Linha("DESABILITADO"));
                }
                if (posMovel.isInicializado()) {
                    layoutDisplay.addLinha(new Linha("NECESSARIO REINICIAR", 0, 1));
                    layoutDisplay.addLinha(new Linha(OPCAO_CLIENT_SERVICO));
                } else {
                    layoutDisplay.addLinha(new Linha("NECESSARIO INICIAR", 0, 1));
                    layoutDisplay.addLinha(new Linha(OPCAO_CLIENT_SERVICO));
                }
                ControladorConfCTFClient.getInstance().save(confCTFClient);
                perifericos.confirmaDado(layoutDisplay);
                continue;
            }
            if (opcao != 2) continue;
            boolean sairMenu = false;
            while (!sairMenu) {
                String estab = confCTFClient.getEstabelecimento() + confCTFClient.getLoja();
                layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha("CONFIGURACAO -> POS-MOVEL"));
                layoutDisplay.addLinha(new Linha("TERMINAL " + estab + ":"));
                evTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CODIGO_PDV, 0, true, 19, true, confPOSTef.getTerminalPosMovel());
                if (evTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                    return;
                }
                int num = evTeclado.getStringLida().length() - evTeclado.getNumCaracteresDigitados();
                String pdv = evTeclado.getStringLida().substring(num);
                if (pdv == null || "".equals(pdv) || pdv.trim().length() < 3) {
                    layoutDisplay = new LayoutDisplay("CODIGO DO TERMINAL INVALIDO");
                    perifericos.confirmaDado(layoutDisplay);
                    continue;
                }
                if (confPOSTef != null) {
                    confPOSTef.setTerminalPosMovel(pdv);
                }
                sairMenu = true;
            }
            if (!sairMenu) continue;
            ControladorConfCTFClient.getInstance().save(confCTFClient);
            LayoutDisplay layoutDisplay2 = new LayoutDisplay();
            layoutDisplay2 = new LayoutDisplay();
            layoutDisplay2.addLinha(new Linha("COD. TERMINAL POS-MOVEL"));
            layoutDisplay2.addLinha(new Linha("CONFIGURADO"));
            if (confPOSTef.isHabilitado()) {
                if (posMovel.isInicializado()) {
                    layoutDisplay2.addLinha(new Linha("NECESSARIO REINICIAR", 0, 1));
                    layoutDisplay2.addLinha(new Linha(OPCAO_CLIENT_SERVICO));
                } else {
                    layoutDisplay2.addLinha(new Linha("NECESSARIO INICIAR", 0, 1));
                    layoutDisplay2.addLinha(new Linha(OPCAO_CLIENT_SERVICO));
                }
            } else {
                layoutDisplay2.addLinha(new Linha("NECESSARIO HABILITAR", 0, 1));
                layoutDisplay2.addLinha(new Linha(OPCAO_POS_MOVEL));
            }
            perifericos.confirmaDado(layoutDisplay2);
        }
    }
}

