/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.ControladorDetectaPinpad;
import com.csi.ctfclient.tools.util.StringUtil;
import java.io.File;
import java.util.Objects;

public class MicConfigurePinpad {
    private static final String MENU_OPTION_MANUAL = "MANUAL";
    private static final String MENU_OPTION_AUTO = "AUTOMATICA";
    private static final String PINPAD_PROMPT_DEFAULT = "Auttar";
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    public static String SUCCESS = "SUCCESS";
    public static String ERROR = "ERROR";
    public static String USER_CANCEL = "USER_CANCEL";

    public String execute(Process process) throws ExcecaoNaoLocal {
        logger.info("Iniciando configura\u00e7\u00e3o do pinpad");
        ControladorPerifericos peripherals = process.getPerifericos();
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        return this.showMainOptions(peripherals, confCTFClient);
    }

    private String showMainOptions(ControladorPerifericos peripherals, ConfCTFClient confCTFClient) {
        LayoutMenu layoutMenu = new LayoutMenu("CONFIGURACAO -> PINPAD", true);
        layoutMenu.addItem(new ItemMenu(MENU_OPTION_MANUAL, "1"));
        layoutMenu.addItem(new ItemMenu(MENU_OPTION_AUTO, "2"));
        try {
            int menuOption;
            while ((menuOption = peripherals.imprimeMenu(layoutMenu)) != -1) {
                ItemMenu itemMenu = layoutMenu.getItens().get(menuOption - 1);
                switch (itemMenu.getTexto()) {
                    case "MANUAL": {
                        return this.processManual(peripherals, confCTFClient);
                    }
                    case "AUTOMATICA": {
                        return this.processAutomatic(peripherals, confCTFClient);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("Erro no menu de configura\u00e7\u00e3o de pinpad: " + ex.getLocalizedMessage());
            return ERROR;
        }
        return USER_CANCEL;
    }

    private String processManual(ControladorPerifericos peripherals, ConfCTFClient confCTFClient) throws Exception {
        boolean isInputValid = false;
        String serialPort = "";
        while (!isInputValid) {
            LayoutDisplay layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("CONFIGURACAO -> PINPAD"));
            layoutDisplay.addLinha(new Linha("PORTA:"));
            EventoTeclado keyboardEvent = (EventoTeclado)peripherals.captureDataAlignedLeft(layoutDisplay, ConstantesApiAc.CAP_PINPAD_PORTA, this.getCurrentPinSerialPort(confCTFClient));
            if ("VOLTA".equals(keyboardEvent.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            serialPort = keyboardEvent.getStringLida().trim();
            if (serialPort.equals("")) {
                layoutDisplay = new LayoutDisplay("PORTA SERIAL INVALIDA");
                peripherals.confirmaDado(layoutDisplay);
                continue;
            }
            isInputValid = true;
        }
        return this.configurePinpad(peripherals, serialPort, confCTFClient);
    }

    private String processAutomatic(ControladorPerifericos peripherals, ConfCTFClient confCTFClient) throws ExcecaoNaoLocal {
        String serialPort;
        try {
            ControladorDetectaPinpad pinpadDetectionController = ControladorDetectaPinpad.getInstancia();
            serialPort = pinpadDetectionController.detectaPinpad(peripherals);
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            logger.error("Nao foi possivel realizar a deteccao do pinpad: " + excecaoPerifericos.getMessage());
            return ERROR;
        }
        if (serialPort == null) {
            LayoutDisplay layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("PINPAD NAO DETECTADO"));
            peripherals.confirmaDado(layoutDisplay);
            return USER_CANCEL;
        }
        return this.configurePinpad(peripherals, serialPort, confCTFClient);
    }

    private String configurePinpad(ControladorPerifericos peripherals, String serialPort, ConfCTFClient confCTFClient) throws ExcecaoNaoLocal {
        if (!this.verifyCSIFile() || !this.verifySERFile()) {
            LayoutDisplay layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("ERRO NA CONFIGURA\u00c7\u00c3O"));
            peripherals.confirmaDado(layoutDisplay);
            return ERROR;
        }
        String messagePrompt = this.getMessagePrompt(peripherals, confCTFClient);
        if (messagePrompt == null) {
            return USER_CANCEL;
        }
        LayoutDisplay layoutDisplay = new LayoutDisplay();
        layoutDisplay.addLinha(new Linha("CONFIGURANDO PINPAD"));
        layoutDisplay.addLinha(new Linha("AGUARDE..."));
        peripherals.imprimeDisplay(layoutDisplay);
        Objects.requireNonNull(ControladorConfCTFClient.getInstance()).configuraPinpad(serialPort, messagePrompt);
        layoutDisplay = new LayoutDisplay();
        layoutDisplay.addLinha(new Linha("PINPAD CONFIGURADO"));
        layoutDisplay.addLinha(new Linha("NA PORTA: " + serialPort));
        peripherals.confirmaDado(layoutDisplay);
        return SUCCESS;
    }

    private String getMessagePrompt(ControladorPerifericos peripherals, ConfCTFClient confCTFClient) throws ExcecaoNaoLocal {
        LayoutDisplay layoutDisplay = new LayoutDisplay("CONFIGURACAO -> PINPAD");
        layoutDisplay.addLinha(new Linha("MENSAGEM DO PINPAD:"));
        EventoTeclado keyboardEvent = (EventoTeclado)peripherals.captureDataAlignedLeft(layoutDisplay, ConstantesApiAc.CAP_PINPAD_PROMPT, this.getCurrentPinMsgPrompt(confCTFClient));
        if ("VOLTA".equals(keyboardEvent.getTeclaFinalizadora())) {
            return null;
        }
        String result = keyboardEvent.getStringLida().trim();
        if (StringUtil.isEmpty(keyboardEvent.getStringLida())) {
            return PINPAD_PROMPT_DEFAULT;
        }
        return result;
    }

    private String getCurrentPinSerialPort(ConfCTFClient confCTFClient) {
        if (confCTFClient == null || confCTFClient.getPin() == null || confCTFClient.getPin().getParametros().length < 4) {
            return null;
        }
        return confCTFClient.getPin().getParametros()[0];
    }

    private String getCurrentPinMsgPrompt(ConfCTFClient confCTFClient) {
        if (confCTFClient == null || confCTFClient.getPin() == null || confCTFClient.getPin().getParametros().length < 4) {
            return PINPAD_PROMPT_DEFAULT;
        }
        return confCTFClient.getPin().getParametros()[1];
    }

    private boolean verifyCSIFile() {
        File CSIFile = new File("CSICFG");
        if (CSIFile.exists()) {
            return CSIFile.delete();
        }
        return true;
    }

    private boolean verifySERFile() {
        File SERFile = new File("SERCFG");
        if (SERFile.exists()) {
            return SERFile.delete();
        }
        return true;
    }
}

