/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.CnpjUtil;
import java.util.Objects;

public class MicConfigureTerminal {
    private static final int COMPANY_INPUT_MIN_LENGTH = 5;
    private static final int STORE_INPUT_MIN_LENGTH = 4;
    private static final int PDV_INPUT_MIN_LENGTH = 3;
    private static final int CNPJ_INPUT_MIN_LENGTH = 14;
    public static String SUCCESS = "SUCCESS";
    public static String ERROR = "ERROR";
    public static String USER_CANCEL = "USER_CANCEL";
    public static String UNNECESSARY = "UNNECESSARY";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process process) throws ExcecaoNaoLocal {
        boolean shouldExit;
        ControladorConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance());
        ContextoCTFClient context = Contexto.getContexto();
        boolean isManualOverride = context.isManualConfigOverride();
        if (isManualOverride) {
            logger.info("Configura\u00e7\u00e3o manual inicializada.");
        } else {
            if (this.isConfigured(confCTFClient)) {
                logger.info("Configura\u00e7\u00e3o autom\u00e1tica n\u00e3o \u00e9 necess\u00e1ria. Ignorando.");
                return UNNECESSARY;
            }
            if (confCTFClient.isMultiEc()) {
                logger.info("Pulando validacao do terminal para instalacoes multi-ec");
                return UNNECESSARY;
            }
        }
        context.setManualConfigOverride(false);
        ControladorPerifericos peripherals = process.getPerifericos();
        String company = this.getCompanyInput(peripherals);
        String store = company != null ? this.getStoreInput(peripherals) : null;
        String pdv = store != null ? this.getPDVInput(peripherals) : null;
        String cnpj = confCTFClient.getConfig().getCnpj();
        if (isManualOverride) {
            cnpj = pdv != null ? this.getCompanyCNPJInput(peripherals) : null;
        }
        boolean bl = shouldExit = company == null || store == null || pdv == null;
        if (!shouldExit) {
            IdentApiTefC id = context.getIdentApiTefC();
            confCTFClient.getConfig().setEstabelecimento(company);
            id.setNumeroEstabelecimento(company);
            confCTFClient.getConfig().setLoja(store);
            id.setNumeroLoja(store);
            confCTFClient.getConfig().setTerminal(pdv);
            id.setNumeroPdv(pdv);
            confCTFClient.getConfig().setCnpj(cnpj);
            confCTFClient.save(confCTFClient.getConfig());
            LayoutDisplay layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("TERMINAL CONFIGURADO"));
            peripherals.confirmaDado(layoutDisplay);
            logger.info(String.format("Terminal Configurado (Est: %s Loja: %s PDV: %s CNPJ: %s)", company, store, pdv, cnpj));
            return SUCCESS;
        }
        logger.info("Cancelamento do Usu\u00e1rio");
        return USER_CANCEL;
    }

    private boolean isConfigured(ControladorConfCTFClient confCTFClient) {
        return confCTFClient.isEstabelecimentoValido() && confCTFClient.isLojaValida() && confCTFClient.isTerminalValido();
    }

    private String getCompanyInput(ControladorPerifericos peripherals) throws ExcecaoNaoLocal {
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        String result = "";
        while (result.length() < 5) {
            LayoutDisplay layoutDisplay = new LayoutDisplay("CONFIGURACAO -> TERMINAL");
            layoutDisplay.addLinha(new Linha("EMPRESA:"));
            EventoTeclado keyboardEvent = (EventoTeclado)peripherals.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CODIGO_EMPRESA, confCTFClient.getEstabelecimento());
            if (keyboardEvent.getTeclaFinalizadora().equals("VOLTA")) {
                return null;
            }
            result = keyboardEvent.getStringLida().trim();
        }
        return result;
    }

    private String getStoreInput(ControladorPerifericos peripherals) throws ExcecaoNaoLocal {
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        String result = "";
        while (result.length() < 4) {
            LayoutDisplay layoutDisplay = new LayoutDisplay("CONFIGURACAO -> TERMINAL");
            layoutDisplay.addLinha(new Linha("LOJA:"));
            EventoTeclado keyboardEvent = (EventoTeclado)peripherals.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CODIGO_LOJA, confCTFClient.getLoja());
            if (keyboardEvent.getTeclaFinalizadora().equals("VOLTA")) {
                return null;
            }
            result = keyboardEvent.getStringLida().trim();
        }
        return result;
    }

    private String getPDVInput(ControladorPerifericos peripherals) throws ExcecaoNaoLocal {
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        String result = "";
        while (result.length() < 3) {
            LayoutDisplay layoutDisplay = new LayoutDisplay("CONFIGURACAO -> TERMINAL");
            layoutDisplay.addLinha(new Linha("PDV:"));
            EventoTeclado keyboardEvent = (EventoTeclado)peripherals.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CODIGO_PDV, confCTFClient.getTerminal());
            if (keyboardEvent.getTeclaFinalizadora().equals("VOLTA")) {
                return null;
            }
            result = keyboardEvent.getStringLida().trim();
        }
        return result;
    }

    private String getCompanyCNPJInput(ControladorPerifericos peripherals) throws ExcecaoNaoLocal {
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        String result = "";
        while (result.length() < 14) {
            LayoutDisplay layoutDisplay = new LayoutDisplay("CONFIGURACAO -> TERMINAL");
            layoutDisplay.addLinha(new Linha("CNPJ:"));
            EventoTeclado keyboardEvent = (EventoTeclado)peripherals.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CNPJ, confCTFClient.getCnpj() != null ? confCTFClient.getCnpj() : "");
            if (keyboardEvent.getTeclaFinalizadora().equals("VOLTA")) {
                return null;
            }
            result = keyboardEvent.getStringLida().trim();
            if (CnpjUtil.validaCnpj(result)) continue;
            layoutDisplay = new LayoutDisplay("CNPJ INVALIDO");
            peripherals.confirmaDado(layoutDisplay);
            result = "";
        }
        return result;
    }
}

