/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.util.StringUtil;

public class MicDesfazimentoOperacaoTransacaoCorrente {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        PinInfo pinInfo;
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        IdentApiTefC ident = Contexto.getContexto().getIdentApiTefC();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC numTrans = dados.getApitef().getTransactionNumber(ident, entradaApiTefC);
        if (numTrans.getRetorno() != 0) {
            logger.error("N\u00e3o foi poss\u00edvel ler o c\u00f3digo da \u00faltima transa\u00e7\u00e3o.");
            return ERROR;
        }
        entradaApiTefC.setNumeroTransacao(numTrans.num_trans());
        SaidaApiTefC saidaOriginal = Contexto.getContexto().getSaidaApiTefC();
        if (saidaOriginal != null) {
            entradaApiTefC.setNsuCtfTransacaoOriginal(saidaOriginal.getNsuCTF());
        }
        if (entradaApiTefC.getStatusComunicacaoHost() == 0 && (pinInfo = Contexto.getContexto().getPinInfo()) != null) {
            entradaApiTefC.setDecisaoChip(StringUtil.completaString(pinInfo.getDecisaoFinishChip() + "", 1, ' ', 3).toCharArray()[0]);
        }
        if (entradaApiTefC.getMotivoDesfazimento() != 0) {
            logger.info("Motivo do desfazimento: " + entradaApiTefC.getMotivoDesfazimento());
        }
        logger.info("enviando transa\u00e7\u00e3o de desfazimento");
        SaidaApiTefC saida = dados.getApitef().desfazimento(ident, entradaApiTefC);
        logger.info("transa\u00e7\u00e3o de desfazimento enviada: " + saida.getRetorno());
        if (entradaIntegracao != null && (entradaIntegracao.getOperacao() == OperationEnum.OP_DESFAZIMENTO.getKey().intValue() || entradaIntegracao.getOperacao() == OperationEnum.OP_DESFAZIMENTO_TODAS_TRANS.getKey().intValue())) {
            Contexto.getContexto().setSaidaApiTefC(saida);
        }
        logger.debug("N\u00famero da transa\u00e7\u00e3o: " + entradaApiTefC.getNumeroTransacao());
        logger.debug("Motivo da rejei\u00e7\u00e3o: " + entradaApiTefC.getTipoResposta());
        if (entradaApiTefC.getTipoResposta() != null && entradaApiTefC.getTipoResposta().equals("2")) {
            String mensagem = (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV) && Integer.parseInt(entradaApiTefC.getCodigoRedeAdquirenteChip()) == 2 ? "TRANSACAO NEGADA LIGUE EMISSOR" : "TRANS. NAO AUT. PELO CARTAO";
            String mensagemFormatada = StringUtil.completaString("" + mensagem.length(), 4, '0', 3);
            Contexto.getContexto().getSaidaApiTefC().setDisplayCTF(mensagemFormatada + mensagem);
            Contexto.getContexto().getSaidaApiTefC().setRetorno(11);
        } else if (Contexto.getContexto().getErrorCode() > 0) {
            String msg = StringUtil.completaString("" + "ERRO NO CARTAO COM CHIP".length(), 4, '0', 3);
            Contexto.getContexto().getSaidaApiTefC().setDisplayCTF(msg + "ERRO NO CARTAO COM CHIP");
            Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
        }
        return SUCCESS;
    }
}

