/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.model.ProdutoSimulacaoCrediario;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;

public class MicDetalhamentoSimulacaoCrediario {
    public static final String CONFIRMED = "CONFIRMED";
    public static final String LEGACY = "LEGACY";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR = "ERROR";

    private void mostraCupomDisplay(LayoutDisplay display, ProdutoSimulacaoCrediario selecionado) {
        String[] linhas;
        for (String linha : linhas = selecionado.getCupom(32).split("#")) {
            display.addLinha(new Linha(linha));
        }
    }

    private boolean confirmaCupom(LayoutDisplay display, Process processo) throws ExcecaoNaoLocal {
        EventoTeclado eventoTeclado = (EventoTeclado)processo.getPerifericos().confirmaDado(display);
        return !"VOLTA".equals(eventoTeclado.getTeclaFinalizadora());
    }

    public String execute(Process processo) throws ExcecaoNaoLocal {
        if (Contexto.getContexto().getSaidaApiTefC().getDadosSimulacaoCrediario() == null) {
            return LEGACY;
        }
        ProdutoSimulacaoCrediario selecionado = Contexto.getContexto().getProdutoSimulacaoCrediarioSelecionado();
        if (selecionado == null) {
            return ERROR;
        }
        LayoutDisplay display = new LayoutDisplay();
        this.mostraCupomDisplay(display, selecionado);
        if (this.confirmaCupom(display, processo)) {
            return CONFIRMED;
        }
        return USER_CANCEL;
    }
}

