/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.model.ProdutoConvenioCombustivel;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;
import com.csi.ctfclient.tools.devices.fusion.StatusFusion;
import com.csi.ctfclient.tools.devices.fusion.StatusPresetFusion;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.ArrayList;
import java.util.Iterator;

public class MicDetectaOperacaoAbastecimento {
    public static final String SUCCESS = "SUCCESS";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String DESFAZER_PRE_VALIDACAO = "DESFAZER_PRE_VALIDACAO";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String ERROR = "ERROR";
    private static final String MSG_OPERATION_NOT_ALLOWED = "OPERACAO NAO PERMITIDA";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (Contexto.getContexto().isConvenioCombustivelPosAutorizado()) {
            if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CONVENIO_COMBUSTIVEL_PRE_VALIDACAO.getDescription())) {
                logger.error("Pr\u00e9-valida\u00e7\u00e3o selecionada, por\u00e9m est\u00e1 em modo conting\u00eancia");
                LayoutDisplay displayModel = new LayoutDisplay();
                displayModel.addLinha(new Linha(inter.getMessage("RECINFABA_ERROR_PRE_VALIDACAO_FUSION_OFFLINE1")));
                displayModel.addLinha(new Linha(inter.getMessage("RECINFABA_ERROR_PRE_VALIDACAO_FUSION_OFFLINE2")));
                perifericos.confirmaDado(displayModel);
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.OPERACAO_NAO_PERMITIDA, MSG_OPERATION_NOT_ALLOWED));
                return ERROR;
            }
            return NOT_REQUIRED;
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENVIO1F_TITLE"));
        perifericos.imprimeDisplay(displayModel);
        ControladorFusion fusion = ControladorFusion.getInstancia();
        String hashCartao = CriptografiaUtil.gerarHash(Contexto.getContexto().getEntradaApiTefC().getPAN(), "SHA-256");
        StatusPresetFusion statusPreset = null;
        try {
            statusPreset = fusion.statusPreset(hashCartao);
        }
        catch (Exception e) {
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_CONEXAO_FUSION, "ERRO CONEXAO FUSION"));
            return ERROR;
        }
        if (statusPreset.getResultado() == 0) {
            ArrayList<String> mensagensErro = new ArrayList<String>();
            switch (statusPreset.getStatusPreset()) {
                case 1: {
                    if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CONVENIO_COMBUSTIVEL_AUTORIZACAO.getDescription())) {
                        logger.error("Abastecimento ainda n\u00e3o realizado");
                        mensagensErro.add(inter.getMessage("RECINFABA_ERROR_AUTORIZADO"));
                        break;
                    }
                    String mensagemDesfazerAbastecimento = statusPreset.getBomba() != null && statusPreset.getBomba().getId() > 0 ? "BOMBA " + statusPreset.getBomba().getId() + " LIBERADA, REFAZER LIBER?" : inter.getMessage("DETOPEABA_DESFAZER_ABASTECIMENTO_AUTORIZADO_TITLE");
                    LayoutMenu layoutMenu = new LayoutMenu(mensagemDesfazerAbastecimento, true);
                    layoutMenu.addItem(new ItemMenu(inter.getMessage("DETOPEABA_DESFAZER_ABASTECIMENTO_AUTORIZADO_SIM"), "1"));
                    layoutMenu.addItem(new ItemMenu(inter.getMessage("DETOPEABA_DESFAZER_ABASTECIMENTO_AUTORIZADO_NAO"), "2"));
                    int opcao = perifericos.imprimeMenu(layoutMenu);
                    if (opcao == -1) {
                        return USER_CANCEL;
                    }
                    if (opcao == 1) {
                        StatusFusion statusFusion = null;
                        try {
                            statusFusion = fusion.cancelarPreset(hashCartao);
                        }
                        catch (Exception e) {
                            logger.warn("Erro ao cancelar o preset: " + e.getMessage());
                        }
                        if (statusFusion == null || statusFusion.getResultado() != 0) {
                            logger.warn("Erro ao cancelar o preset, resultado: " + statusFusion.getResultado() + ", status: " + statusFusion.getStatusFusion());
                        }
                        return DESFAZER_PRE_VALIDACAO;
                    }
                    if (opcao == 2) {
                        logger.error("Abastecimento ainda n\u00e3o realizado");
                        mensagensErro.add(inter.getMessage("RECINFABA_ERROR_AUTORIZADO"));
                        return USER_CANCEL_INTERNAL;
                    }
                    throw new IllegalArgumentException("Op\u00e7\u00e3o de menu inexistente");
                }
                case 5: {
                    if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CONVENIO_COMBUSTIVEL_AUTORIZACAO.getDescription())) {
                        logger.error("Abastecimento ainda n\u00e3o realizado");
                        mensagensErro.add(inter.getMessage("RECINFABA_ERROR_AUTORIZADO"));
                        break;
                    }
                    displayModel = new LayoutDisplay();
                    displayModel.addLinha(new Linha("REFAZENDO AUTORIZACAO DA BOMBA..."));
                    displayModel.setDelay(1500L);
                    perifericos.imprimeDisplay(displayModel);
                    StatusFusion statusFusion = null;
                    try {
                        statusFusion = fusion.cancelarPreset(hashCartao);
                    }
                    catch (Exception e) {
                        logger.warn("Erro ao cancelar o preset: " + e.getMessage());
                    }
                    if (statusFusion == null || statusFusion.getResultado() != 0) {
                        logger.warn("Erro ao cancelar o preset, resultado: " + statusFusion.getResultado() + ", status: " + statusFusion.getStatusFusion());
                    }
                    return DESFAZER_PRE_VALIDACAO;
                }
                case 2: {
                    logger.error("Autoriza\u00e7\u00e3o em abastecimento");
                    mensagensErro.add(inter.getMessage("RECINFABA_ERROR_ABASTECENDO"));
                    break;
                }
                case 3: {
                    logger.error("Bomba bloqueada");
                    mensagensErro.add(inter.getMessage("RECINFABA_ERROR_BLOQUEADO"));
                    break;
                }
                case 4: {
                    if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CONVENIO_COMBUSTIVEL_PRE_VALIDACAO.getDescription())) {
                        logger.error("Abastecimento pronto, por\u00e9m foi selecionado fazer outra pr\u00e9-valida\u00e7\u00e3o");
                        mensagensErro.add(inter.getMessage("RECINFABA_ERROR_AUTORIZADO_SELECIONADO_PRE_VALIDACAO1"));
                        mensagensErro.add(inter.getMessage("RECINFABA_ERROR_AUTORIZADO_SELECIONADO_PRE_VALIDACAO2"));
                        break;
                    }
                    ProdutoConvenioCombustivel produto = new ProdutoConvenioCombustivel();
                    produto.setCodigo(statusPreset.getCodigoProduto());
                    ArrayList<ProdutoConvenioCombustivel> listProdutoConvenioCombustivel = new ArrayList<ProdutoConvenioCombustivel>();
                    EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
                    entrada.setListProdutoConvenioCombustivel(listProdutoConvenioCombustivel);
                    entrada.setLitros(statusPreset.getVolumeFinal());
                    entrada.setValorTransacao(statusPreset.getPrecoFinal());
                    entrada.setPrecoUnitarioLitroCombustivel(statusPreset.getPrecoUnitario());
                    entrada.setCodigoAutorizacaoFusion(statusPreset.getCodigoAutorizacaoFusion());
                    Contexto.getContexto().setHashCartao(hashCartao);
                    return SUCCESS;
                }
                default: {
                    logger.error("Retorno do status do preset n\u00e3o esperado: [" + statusPreset.getStatusPreset() + "]");
                }
            }
            if (mensagensErro.size() == 0) {
                mensagensErro.add(inter.getMessage("RECINFABA_ERROR_DEFAULT"));
            }
            displayModel = new LayoutDisplay();
            Iterator iteErros = mensagensErro.iterator();
            while (iteErros.hasNext()) {
                displayModel.addLinha(new Linha((String)iteErros.next()));
            }
            perifericos.confirmaDado(displayModel);
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.OPERACAO_NAO_PERMITIDA, MSG_OPERATION_NOT_ALLOWED));
            return ERROR;
        }
        if (statusPreset.getResultado() == 2) {
            if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CONVENIO_COMBUSTIVEL_AUTORIZACAO.getDescription())) {
                logger.error("Autoriza\u00e7\u00e3o selecionada, por\u00e9m foi realizada uma pr\u00e9-valida\u00e7\u00e3o");
                displayModel = new LayoutDisplay(inter.getMessage("RECINFABA_ERROR_PRE_VALIDACAO_SELECIONADO_AUTORIZACAO"));
                perifericos.confirmaDado(displayModel);
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.OPERACAO_NAO_PERMITIDA, MSG_OPERATION_NOT_ALLOWED));
                return ERROR;
            }
            return SUCCESS;
        }
        logger.error("Erro ao tentar recuperar as informa\u00e7\u00f5es do abastecimento, c\u00f3digo: " + statusPreset.getResultado());
        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_CONEXAO_FUSION, "ERRO CONEXAO FUSION"));
        return ERROR;
    }
}

