/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.QrCodeGenerator;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import java.util.Objects;

public class MicDisplayQrCode
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        ConfCTFClient config = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        if (!config.isIntegracaoAndroid()) {
            dados.getPerifericos().waitMessage();
        } else {
            dados.getPerifericos().limpaDisplay();
        }
        QrCodeGenerator qrCodeGenerator = dados.getqrCodeGenerator();
        byte[] qrCodeImage = qrCodeGenerator.createQrCode(Contexto.getContexto().getSaidaApiTefC().getQrcodeImageString());
        String pinCode = Contexto.getContexto().getSaidaApiTefC().getQrcodePinpadCode();
        String transactionValue = Contexto.getContexto().getEntradaApiTefC().getValorTransacao().toString();
        if (!this.showQrCodeOnPinpadDisplay(qrCodeGenerator, qrCodeImage, pinCode, transactionValue)) {
            this.showQrCodeOnOperatorDisplay(dados, config, qrCodeImage, pinCode, transactionValue);
        } else {
            dados.getPerifericos().solicitationMessage();
        }
        return SUCCESS;
    }

    private boolean showQrCodeOnPinpadDisplay(QrCodeGenerator qrCodeGenerator, byte[] qrCodeImage, String pinCode, String transactionValue) {
        try {
            qrCodeGenerator.showQrCode(qrCodeImage, pinCode, transactionValue, this.getTransactionName());
            return true;
        }
        catch (Exception e) {
            this.logger.error("Erro ao exibir QR Code no pin: " + e.getMessage());
            if (pinCode != null) {
                this.tryShowMessagePinpad("  DIGITE " + pinCode + "     NO CELULAR");
            }
            return false;
        }
    }

    private void showQrCodeOnOperatorDisplay(Process dados, ConfCTFClient config, byte[] qrCodeImage, String pinCode, String transactionValue) {
        if (config.isIntegracaoAndroid() || config.isIntegracaoDll()) {
            this.logger.info("Pulando exibi\u00e7\u00e3o de QR Code em integra\u00e7\u00f5es n\u00e3o suportadas");
            return;
        }
        this.logger.info("Exibindo QR Code na tela do operador");
        try {
            String header = Objects.requireNonNull(this.getTransactionName()).toUpperCase() + " R$" + transactionValue;
            String footer = this.buildFooter(pinCode);
            dados.getPerifericos().printPNG(header, "APROXIME A C\u00c2MERA", footer, qrCodeImage);
            dados.getPerifericos().setDisplayLocked(true);
        }
        catch (Exception e) {
            this.logger.error("Erro ao imprimir o QRCode no display operador: " + e.getMessage());
        }
    }

    private String buildFooter(String pinCode) {
        if (pinCode == null) {
            return "";
        }
        return "OU DIGITE " + pinCode;
    }

    private String getTransactionName() {
        String op = Contexto.getContexto().getTipoOperacao();
        if (op.equals(OperationEnum.OP_CREDITO.getDescription()) || op.equals(OperationEnum.OP_CREDITO_GENERICO.getDescription()) || op.equals(OperationEnum.OP_CRED_PARC_SEM_JUROS.getDescription()) || op.equals(OperationEnum.OP_CRED_PARC_COM_JUROS.getDescription())) {
            return "Cr\u00e9dito";
        }
        if (op.equals(OperationEnum.OP_CANCELAMENTO_GENERICO.getDescription())) {
            return "Cancelamento";
        }
        if (op.equals(OperationEnum.OP_DEBITO_GENERICO.getDescription())) {
            return "D\u00e9bito";
        }
        if (op.equals(OperationEnum.OP_PIX_PAYMENT.getDescription())) {
            return "Pagamento Pix";
        }
        return null;
    }
}

