/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;

public class MicEnvio1FCartaoPrepago
extends MicAbstractEnvio1F {
    public static final String CAPTURA_VALOR = "CAPTURA_VALOR";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        ContextoCTFClient contexto = Contexto.getContexto();
        SaidaApiTefC saidaApiTefC = contexto.getSaidaApiTefC();
        if (this.isOperacaoOpAtivacaoPreAutorizacaoCartaoPrePago() && !contexto.isSubFluxoConsulta() || saidaApiTefC != null && saidaApiTefC.getRetorno() == 0) {
            return "UNECESSARY";
        }
        EntradaApiTefC entrada = contexto.getEntradaApiTefC();
        if (contexto.getCartao() == null) {
            entrada.setModoEntrada(contexto.getModoEntradaCodigoBarrasCartaoPrepago());
        }
        String retorno = this.genericExecute(dados);
        saidaApiTefC = contexto.getSaidaApiTefC();
        if (saidaApiTefC == null) {
            return "ERRO";
        }
        if (saidaApiTefC.getRetorno() != 0) {
            entrada.setCodigoBarrasCartaoPrepago(null);
            contexto.resetCartao();
        } else if (saidaApiTefC.getValorTransacao() == null) {
            return CAPTURA_VALOR;
        }
        return retorno;
    }

    private boolean isOperacaoOpAtivacaoPreAutorizacaoCartaoPrePago() {
        return Contexto.getContexto().getEntradaIntegracao().getOperacao() == OperationEnum.OP_ATIVACAO_PRE_AUTORIZACAO_CARTAO_PREPAGO.getKey().intValue();
    }

    @Override
    protected String getCodigoTransacao(Process dados1f) {
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao.getOperacao() == OperationEnum.OP_ATIVACAO_CARTAO_PREPAGO.getKey().intValue()) {
            return "FG";
        }
        if (entradaIntegracao.getOperacao() == OperationEnum.OP_PRE_AUTORIZACAO_CARTAO_PREPAGO.getKey().intValue()) {
            return "FM";
        }
        if (entradaIntegracao.getOperacao() == OperationEnum.OP_DESATIVACAO_CARTAO_PREPAGO.getKey().intValue()) {
            return "E9";
        }
        if (entradaIntegracao.getOperacao() == OperationEnum.OP_ATIVACAO_PRE_AUTORIZACAO_CARTAO_PREPAGO.getKey().intValue()) {
            if (Contexto.getContexto().isSubFluxoConsulta()) {
                return "FM";
            }
            return "FG";
        }
        if (entradaIntegracao.getOperacao() == OperationEnum.OP_VENDA_FASTPIN.getKey().intValue()) {
            return "FJ";
        }
        if (entradaIntegracao.getOperacao() == OperationEnum.OP_RETORNO_FASTPIN.getKey().intValue()) {
            return "FL";
        }
        return "";
    }
}

