/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import java.math.BigDecimal;

public class MicEnvio1FConsultaCartao
extends MicAbstractEnvio1F {
    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        this.setValorTransacao();
        this.setPermiteAprovacaoValorParcial();
        return this.genericExecute(dados);
    }

    private void setPermiteAprovacaoValorParcial() throws ExcecaoNaoLocal {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.isPermiteAprovacaoValorParcialCtrl()) {
            this.logger.info("Permite aprova\u00e7\u00e3o do valor parcial (AC): " + entradaIntegracao.isPermiteAprovacaoValorParcial());
            entradaApiTefC.setPermiteAprovacaoValorParcial(entradaIntegracao.isPermiteAprovacaoValorParcial());
        } else {
            ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
            this.logger.info("Pagamento com saldo do voucher (Config Client): " + conf.isPermitePagarSaldoVoucher());
            entradaApiTefC.setPermiteAprovacaoValorParcial(conf.isPermitePagarSaldoVoucher());
        }
    }

    private void setValorTransacao() {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getValorTransacao() == null) {
            EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
            if (entradaIntegracao.isValorTransacaoCtrl()) {
                entradaApiTefC.setValorTransacao(entradaIntegracao.getValorTransacao());
            } else {
                entradaApiTefC.setValorTransacao(BigDecimal.ONE);
            }
        }
    }

    @Override
    protected String getCodigoTransacao(Process dados1F) {
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.isCodigoTransacaoCtrl()) {
            return entradaIntegracao.getCodigoTransacao();
        }
        throw new IllegalStateException("Codigo transa\u00e7\u00e3o n\u00e3o encontrada!");
    }
}

