/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;

public class MicEnvio1FMenuDinamico
extends MicAbstractEnvio1F {
    public static final String UNNECESSARY = "UNNECESSARY";
    protected boolean timeoutCustomizado;

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (saidaApiTefC != null && saidaApiTefC.getRetorno() == 0) {
            return UNNECESSARY;
        }
        boolean vencimentoDefault = this.setDataVencimentoQuandoCartaoDigitadoPara1DiaNoFuturo();
        if (entradaIntegracao != null) {
            if (entradaIntegracao.isPermiteAprovacaoValorParcialCtrl()) {
                this.logger.info("Pagamento com saldo do voucher (AC): " + entradaIntegracao.isPermiteAprovacaoValorParcial());
                entrada.setPermiteAprovacaoValorParcial(entradaIntegracao.isPermiteAprovacaoValorParcial());
            }
            if (entradaIntegracao.isTipoAutorizadoraCtrl()) {
                this.logger.info("Tipo da autorizadora: " + entradaIntegracao.getTipoAutorizadora());
                entrada.setTipoAutorizadora(entradaIntegracao.getTipoAutorizadora());
            }
            if (entradaIntegracao.isExecutaFinanciamentoAutorizadoraCtrl()) {
                this.logger.info("Executa Financiamento Autorizadora: " + entradaIntegracao.isExecutaConsultaFinanciamentoAutorizadora());
                entrada.setExecutaFinanciamentoAutorizadora(entradaIntegracao.isExecutaConsultaFinanciamentoAutorizadora());
                this.timeoutCustomizado = true;
            }
        }
        String retorno = this.genericExecute(dados);
        if (vencimentoDefault) {
            entrada.setDataVencimento(null);
        }
        return retorno;
    }

    @Override
    protected int getTimeout1F() {
        int timeout1F = super.getTimeout1F();
        if (this.timeoutCustomizado) {
            return timeout1F + 15;
        }
        return timeout1F;
    }

    @Override
    protected String getCodigoTransacao(Process dados1F) {
        if (OperationEnum.OP_CREDITO_GENERICO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                return "24";
            }
            return "12";
        }
        if (OperationEnum.OP_DEBITO_GENERICO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "10";
        }
        if (OperationEnum.OP_OUTRAS_TRANSACOES.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "2R";
        }
        if (OperationEnum.OP_DEB_VOUCHER.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "6A";
        }
        if (OperationEnum.OP_CONSULTA_CDC_COM_PARC_AVISTA.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_CONSULTA_CDC_SEM_PARC_AVISTA.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "5C";
        }
        if (OperationEnum.OP_CANCELAMENTO_GENERICO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "2W";
        }
        if (OperationEnum.OP_CREDIARIO_DE_DEBITO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "GB";
        }
        if (OperationEnum.OP_SIMULACAO_CREDIARIO_DE_CREDITO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "4F";
        }
        if (OperationEnum.OP_CREDIARIO_DE_CREDITO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "1S";
        }
        throw new IllegalStateException("Codigo transa\u00e7\u00e3o n\u00e3o encontrada!");
    }
}

