/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.Produto;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import java.math.BigDecimal;

public class MicEnvio1FPreAutorizacao
extends MicAbstractEnvio1F {
    @Override
    public String derivedExecute(Process dado) throws ExcecaoNaoLocal {
        this.setDataVencimentoQuandoCartaoDigitadoPara1DiaNoFuturo();
        String result = this.genericExecute(dado);
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (saida != null) {
            Produto produto;
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO && saida.isSolicitarDataVencimentoCartao()) {
                Contexto.getContexto().getEntradaApiTefC().setDataVencimento(null);
            }
            if ((produto = saida.getProduto()) != null) {
                Contexto.getContexto().getEntradaApiTefC().setCodigoProduto(produto.getCodigo());
                Contexto.getContexto().getEntradaApiTefC().setFluxoTef(produto.getKeyFluxo());
                Contexto.getContexto().getEntradaApiTefC().setCodigoBandeira(produto.getCodigoBandeira());
            }
        }
        return result;
    }

    @Override
    protected String getCodigoTransacao(Process dados1F) {
        if (OperationEnum.OP_PRE_AUT_CRED.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                return "7D";
            }
            if (Contexto.getContexto().isCartaoNaoDigitado()) {
                return "5F";
            }
        } else if (OperationEnum.OP_ALTERACAO_PRE_AUT.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getEntradaApiTefC().getValorTransacao() == null || Contexto.getContexto().getEntradaApiTefC().getValorTransacao().equals(BigDecimal.ZERO)) {
                return "GJ";
            }
            return "GI";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

