/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvioConsulta;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;

public class MicEnvioCargaTabelaGetCard
extends MicAbstractEnvioConsulta {
    public static final String CARGA_TABELA_GETCARD = "CARGA_TABELA_GETCARD";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    @Override
    public String execute(Process dados) throws ExcecaoNaoLocal {
        String retorno = "UNECESSARY";
        if (Contexto.getContexto().getTentativasGetCard() >= 1 && Contexto.getContexto().getCartao() == null || this.isCartaoDiferenteDeChipOuContactLessEmv()) {
            return "UNECESSARY";
        }
        IdentTerminal identTerminal = this.createIdentTerminal();
        DadosInicioDia inicioDia = ControladorInicioDia.getInstance().getDadosInicioDia(identTerminal);
        if (inicioDia.getCargaTabelaGetCard() == 0) {
            return "UNECESSARY";
        }
        if (inicioDia.getCargaTabelaGetCard() == 2 && inicioDia.getErrosCargaTabelaGetcard().contains(String.valueOf(Contexto.getContexto().getErrorCode()))) {
            retorno = this.genericExecute(dados);
            SaidaApiTefC saidaConsulta = Contexto.getContexto().getSaidaConsulta();
            if (saidaConsulta.getRetorno() == 0) {
                if (saidaConsulta.getFlagCargaTabela() == '1') {
                    if (saidaConsulta.getTipoBibliotecaPinpad() == 2) {
                        ProtocoloBibliotecaCompartilhada.setBcType(2);
                    }
                    retorno = this.solicitarCargaTabelas(dados, saidaConsulta);
                } else {
                    retorno = "UNECESSARY";
                }
            }
        }
        Contexto.getContexto().setTentativasGetCard(Contexto.getContexto().getTentativasGetCard() + 1);
        return retorno;
    }

    protected String solicitarCargaTabelas(Process dados, SaidaApiTefC saidaConsulta) throws ExcecaoNaoLocal {
        ControladorPerifericos periferico = dados.getPerifericos();
        try {
            if (periferico.getLeitorCartao() != null) {
                logger.info("NECESSITA REALIZAR CARGA DE TABELA - Carga de tabelas erros GetCard");
                if (saidaConsulta.getTipoBibliotecaPinpad() == 2) {
                    CMOSPinPad.getInstance().solicitarCargaTabelas(periferico.getLeitorCartao().getRedeAdquirente());
                } else {
                    CMOSPinPad.getInstance().solicitarCargaTabelas(0);
                }
                periferico.getLeitorCartao().setSolicitaCargaTabelas(LeitorCartao.CARGA_TABELA_SOLICITADA);
            }
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            logger.error("Nao foi possivel solicitar a carga de tabelas: " + excecaoPerifericos.getMessage());
            return "ERROR";
        }
        return CARGA_TABELA_GETCARD;
    }

    protected IdentTerminal createIdentTerminal() throws ExcecaoNaoLocal {
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (Contexto.getContexto().getEntradaIntegracao() != null && conf.isMultiEC()) {
            return Contexto.getContexto().getEntradaIntegracao().getIdentTerminal();
        }
        return new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
    }

    protected boolean isCartaoDiferenteDeChipOuContactLessEmv() {
        Cartao cartao = Contexto.getContexto().getCartao();
        return cartao != null && cartao != Cartao.CHIP && cartao != Cartao.CONTACTLESS_EMV;
    }

    @Override
    protected String getCodigoTransacao(Process dados) {
        if (OperationEnum.OP_DEBITO_GENERICO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "10";
        }
        if (OperationEnum.OP_CREDITO_GENERICO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "12";
        }
        if (OperationEnum.OP_PGTO_FICHA_COMPENSACAO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "E6";
        }
        if (OperationEnum.OP_PGTO_CONVENIO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "E7";
        }
        return "00";
    }

    @Override
    protected String getOperacao() {
        return "5N";
    }
}

