/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import br.com.auttar.operation.util.TransactionOperationRules;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.SimpleDateFormat;

public class MicEnvioTrasacaoCredito
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    public static final String CREDITO_REFERIDO = "CREDITO_REFERIDO";
    public static final String ERRO_NAO_AUT_CARTAO = "ERRO_NAO_AUT_CARTAO";

    protected String getCodigoTransacao(Process dados) throws IllegalStateException {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (OperationEnum.OP_CREDITO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                    return "24";
                }
                if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA && entradaApiTefC.getNumeroParcelas() > 1) {
                    return "25";
                }
                if (Contexto.getContexto().getPlano() == Plano.LOJISTA && entradaApiTefC.getNumeroParcelas() > 1) {
                    return "1E";
                }
                if (saidaApiTefC.isRotativoHabilitado()) {
                    return "24";
                }
            } else if (Contexto.getContexto().isCartaoNaoDigitado()) {
                if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                    return "12";
                }
                if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA && entradaApiTefC.getNumeroParcelas() > 1) {
                    return "22";
                }
                if (Contexto.getContexto().getPlano() == Plano.LOJISTA && entradaApiTefC.getNumeroParcelas() > 1) {
                    return "21";
                }
                if (saidaApiTefC.isRotativoHabilitado()) {
                    return "12";
                }
            }
        } else if (OperationEnum.OP_CREDITO_PRIMEIRA_COMPRA.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                    return "48";
                }
                if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA && entradaApiTefC.getNumeroParcelas() > 1) {
                    return "54";
                }
                if (Contexto.getContexto().getPlano() == Plano.LOJISTA && entradaApiTefC.getNumeroParcelas() > 1) {
                    return "54";
                }
            }
        } else {
            if (OperationEnum.OP_PAGAMENTO_FATURA_CARTAO_CREDITO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
                return "GR";
            }
            if (OperationEnum.OP_PAGAMENTO_CONTA_BANCARIA.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
                return "GT";
            }
            if (OperationEnum.OP_PAGAMENTO_CONTA_CONCESSIONARIA.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
                return "GS";
            }
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(ControladorCriptografia.getTabelaCriptografia());
        boolean multiTerminal = false;
        if (entradaIntegracao != null) {
            multiTerminal = entradaIntegracao.isMultiTerminal();
            if (entradaIntegracao.isMccCtrl()) {
                entrada.setMcc(entradaIntegracao.getMcc());
            }
            if (Contexto.getContexto().getEntradaIntegracao().getDadosComplementaresTef() != null) {
                entrada.setDadosComplementaresTef(Contexto.getContexto().getEntradaIntegracao().getDadosComplementaresTef());
            }
            if (Contexto.getContexto().getEntradaIntegracao().getTipoProduto() != null) {
                entrada.setTipoProduto(Contexto.getContexto().getEntradaIntegracao().getTipoProduto());
            }
            if (entradaIntegracao.isCodigoTabelaCtrl()) {
                entrada.setCodigoTabela(entradaIntegracao.getCodigoTabela());
            } else if (conf.getCodigoTabela() > 0) {
                entrada.setCodigoTabela(conf.getCodigoTabela());
            }
        }
        if (!multiTerminal && !Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
            displayModel.setImagem(LayoutDisplay.imagens.aguarde_autorizacao);
            periferico.imprimeDisplay(displayModel);
        }
        entrada.setAcSuportaPlataformaPromocional(conf.isAcSuportaPlataformaPromocional());
        entrada.setClientSuportaPlataformaPromocional(true);
        if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
            entrada.setNumeroParcelas(1);
        }
        if (!(multiTerminal || Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost() || TransactionOperationRules.isTypedOperation())) {
            this.tryShowMessagePinpad(inter.getMessage("ENVIO_TITLE"));
        }
        StringBuffer bit62Formatado = new StringBuffer();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        if (entrada.getDataEmissao() != null) {
            bit62Formatado.append(simpleDateFormat.format(entrada.getDataEmissao()));
        } else {
            bit62Formatado.append("00000000");
            entrada.setDataEmissao(null);
        }
        if (entrada.getNumeroCiclos() >= 0) {
            String ciclos = StringUtil.completaString(entrada.getNumeroCiclos() + "", 2, '0', 3);
            bit62Formatado.append(ciclos);
        } else {
            bit62Formatado.append("00");
            entrada.setNumeroCiclos(0);
        }
        if (entrada.getCodigoAutorizacao() != null) {
            bit62Formatado.append(StringUtil.completaString(entrada.getCodigoAutorizacao(), 6, '0', 3));
        }
        entrada.setAdicionais(bit62Formatado.toString());
        SaidaApiTefC saidaAtual = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        if (Contexto.getContexto().getSaidaApiTefC().isFluxoChipNaoEMV()) {
            saidaAtual.setCapturaDadosChip(Contexto.getContexto().getSaidaApiTefC().getCapturaDadosChip());
        }
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            Contexto.getContexto().setSaidaApiTefC(saidaAtual);
            if (saidaAtual.getRetorno() == 0) {
                VerifyContentUtil.preencheDadosSaida(saidaAtual);
                return SUCESS;
            }
            this.logger.info("Resposta autorizadora: " + saidaAtual.getCodigoRespostaAutorizadora());
            if (saidaAtual.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERRO_TRANS_JA_EFETUADA;
            }
            if (saidaAtual.getCodigoRespostaAutorizadora().equals("077") && saidaAtual.isConfirnacaoPositiva()) {
                return CREDITO_REFERIDO;
            }
            if (saidaAtual.getCodigoRespostaAutorizadora().equals("0F5")) {
                return ERRO_NAO_AUT_CARTAO;
            }
            return ERRO;
        }
        return SUCESS;
    }
}

