/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.ControladorEstatistica;
import com.csi.ctfclient.operacoes.model.DadosEstatistica;

public class MicEstatisticaLeituraCartao
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    private static final int PASSIVEL_FALLBACK = 1;

    @Override
    public String derivedExecute(Process dados) {
        Cartao cartao = Contexto.getContexto().getCartao();
        if (cartao != null && cartao == Cartao.MAGNETICO && Contexto.getContexto().getStatusLeituraCartao() == 1) {
            boolean persistirDados = false;
            try {
                ControladorEstatistica controladorEstatistica = ControladorEstatistica.getInstance();
                DadosEstatistica dadosEstatistica = controladorEstatistica.getDadosEstatistica();
                if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CREDITO.getDescription()) || Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CREDITO_GENERICO.getDescription()) || Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_PRE_AUT_CRED.getDescription()) || Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CONFIRMACAO_PRE_AUT.getDescription())) {
                    dadosEstatistica.addFallbackChipCredito();
                    persistirDados = true;
                } else if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_DEBITO.getDescription()) || Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_DEBITO_GENERICO.getDescription())) {
                    dadosEstatistica.addFallbackChipDebito();
                    persistirDados = true;
                }
                if (persistirDados) {
                    controladorEstatistica.persistirDados(dadosEstatistica);
                }
            }
            catch (ExcecaoApiAc e) {
                this.logger.warn("Erro durante o levantamento de estatisticas do cartao: " + e.getMessage());
            }
        }
        return SUCESS;
    }
}

