/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.ControladorEstatistica;
import com.csi.ctfclient.operacoes.model.DadosEstatistica;

public class MicEstatisticaVerificaComunicacaoCTF
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    public static final String UNECESSARY = "UNECESSARY";

    @Override
    public String derivedExecute(Process dados) {
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        try {
            boolean persistirDados = false;
            ControladorEstatistica controladorEstatistica = null;
            DadosEstatistica dadosEstatistica = null;
            if (saida.getCodigoRespostaAutorizadora().equals("055")) {
                controladorEstatistica = ControladorEstatistica.getInstance();
                dadosEstatistica = controladorEstatistica.getDadosEstatistica();
                if (Contexto.getContexto().getCartao() == Cartao.MAGNETICO) {
                    dadosEstatistica.addErroSenhaPinMagnetico();
                    persistirDados = true;
                } else if (Contexto.getContexto().getCartao() == Cartao.CHIP) {
                    dadosEstatistica.addErroSenhaOnlineChip();
                    persistirDados = true;
                }
            }
            if (persistirDados) {
                controladorEstatistica.persistirDados(dadosEstatistica);
            }
        }
        catch (ExcecaoApiAc e) {
            this.logger.error("Erro durante a verificacao de estatistica de comunicacao: " + e.getMessage());
            return ERROR;
        }
        return SUCESS;
    }
}

