/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.TipoAutorizadora;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessConstructorArguments;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessAtualizacaoChip;
import com.csi.ctfclient.operacoes.action.ProcessAuto;
import com.csi.ctfclient.operacoes.action.ProcessConsultaAvs;
import com.csi.ctfclient.operacoes.action.ProcessConsultaCDC;
import com.csi.ctfclient.operacoes.action.ProcessConvenioCombustivel;
import com.csi.ctfclient.operacoes.action.ProcessCrediario;
import com.csi.ctfclient.operacoes.action.ProcessCredito;
import com.csi.ctfclient.operacoes.action.ProcessCreditoPrivateLabel;
import com.csi.ctfclient.operacoes.action.ProcessDebito;
import com.csi.ctfclient.operacoes.action.ProcessFuelControl;
import com.csi.ctfclient.operacoes.action.ProcessPagamentoContas;
import com.csi.ctfclient.operacoes.action.ProcessPreAutorizacao;
import com.csi.ctfclient.operacoes.action.ProcessResgatePremio;
import com.csi.ctfclient.operacoes.action.ProcessSimulacaoCrediarioCredito;
import com.csi.ctfclient.operacoes.action.ProcessVoucher;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.util.TransacoesGenericas;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.Objects;

public class MicExecutaProcessTransacoesGenericas {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String REDIRECT = "REDIRECT";
    public static final String FLUXO_NOT_FOUND = "FLUXO_NOT_FOUND";
    public static final String FLUXO_NOT_FOUND_AC = "FLUXO_NOT_FOUND_AC";
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private ProcessConstructorArguments processConstructorArguments;

    public String execute(Process dados) throws ExcecaoNaoLocal {
        this.processConstructorArguments = dados.getProcessConstructorArguments();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        TransacoesGenericas transacoesGenericas = TransacoesGenericas.getInstance(saida.getRedeMenuDinamico());
        int qtdProdutos = this.getQtdProdutos(entradaApiTefC, saida);
        int keyFluxo = this.initKeyFluxo(entradaApiTefC, transacoesGenericas);
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_DEBITO && saida.getTipoAutorizadora() == TipoAutorizadora.VOUCHER) {
            keyFluxo = transacoesGenericas.KEY_FLUXO_VOUCHER;
            Contexto.getContexto().setSaidaApiTefC(null);
        }
        if (Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig().isRotearPrivateLabel() && keyFluxo == transacoesGenericas.KEY_FLUXO_CREDITO && saida.getTipoAutorizadora() == TipoAutorizadora.PRIVATE_LABEL) {
            keyFluxo = transacoesGenericas.KEY_FLUXO_CREDITO_PRIVATE_LABEL;
        }
        if ((keyFluxo == transacoesGenericas.KEY_FLUXO_CREDITO || keyFluxo == transacoesGenericas.KEY_FLUXO_DEBITO) && saida.getTipoAutorizadora() == TipoAutorizadora.FUEL_CONTROL) {
            if (saida.getTipoProduto() == 3) {
                return this.processKeyConvenioCombustivel(dados);
            }
            String tipoOperacaoOriginalRedirect = Contexto.getContexto().getTipoOperacao();
            Contexto.getContexto().setTipoOperacao(OperationEnum.OP_FUEL_CONTROL.getDescription());
            return this.processGenericFluxo(dados, this.createProcessFuelControl(), qtdProdutos, tipoOperacaoOriginalRedirect);
        }
        String tipoOperacaoOriginalRedirect = Contexto.getContexto().getTipoOperacao();
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_DEBITO && TipoAutorizadora.AUTO.equals(saida.getTipoAutorizadora())) {
            ProcessAuto processAuto = this.createProcessAuto(transacoesGenericas.KEY_FLUXO_AUTO, transacoesGenericas);
            return this.processGenericFluxo(dados, processAuto, qtdProdutos, tipoOperacaoOriginalRedirect);
        }
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_CREDITO) {
            return this.processGenericFluxo(dados, this.createProcessCredito(), qtdProdutos, tipoOperacaoOriginalRedirect);
        }
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_DEBITO) {
            return this.processGenericFluxo(dados, this.createProcessDebito(), qtdProdutos, tipoOperacaoOriginalRedirect);
        }
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_VOUCHER) {
            return this.processGenericFluxo(dados, this.createProcessVoucher(), qtdProdutos, tipoOperacaoOriginalRedirect);
        }
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_CONSULTA_CDC) {
            Contexto.getContexto().setTipoOperacao(OperationEnum.OP_SIMULACAO_CREDIARIO_DE_CREDITO.getDescription());
            return this.processGenericFluxo(dados, this.createProcessConsulta(OperationEnum.OP_SIMULACAO_CREDIARIO_DE_CREDITO.getDescription()), qtdProdutos, tipoOperacaoOriginalRedirect);
        }
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_PRE_AUTORIZACAO) {
            return this.processGenericFluxo(dados, this.createProcessPreAutorizacao(), qtdProdutos, tipoOperacaoOriginalRedirect);
        }
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_PGTO_CONTAS) {
            return this.processGenericFluxo(dados, this.createProcessPagamentoContas(), qtdProdutos, tipoOperacaoOriginalRedirect);
        }
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_AVS) {
            return this.processKeyFluxoAvs(dados, tipoOperacaoOriginalRedirect);
        }
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_CREDITO_PRIVATE_LABEL) {
            return this.processKeyFluxoCreditoPrivateLabel(dados, tipoOperacaoOriginalRedirect);
        }
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_PLATAFORMA_PROMOCIONAL) {
            return this.processKeyFluxoPlataformaPromocional(dados, tipoOperacaoOriginalRedirect);
        }
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_VOUCHER_FROTA) {
            tipoOperacaoOriginalRedirect = Contexto.getContexto().getTipoOperacao();
            Contexto.getContexto().setTipoOperacao(OperationEnum.OP_FUEL_CONTROL.getDescription());
            return this.processGenericFluxo(dados, this.createProcessFuelControl(), qtdProdutos, tipoOperacaoOriginalRedirect);
        }
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_CREDIARIO) {
            Contexto.getContexto().setTipoOperacao(this.getTipoOperacaoCrediario());
            return this.processGenericFluxo(dados, this.createProcessCrediario(), qtdProdutos, tipoOperacaoOriginalRedirect);
        }
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_ATUALIZACAO_CHIP) {
            return this.processGenericFluxo(dados, this.createProcessAtualizacaoChip(), qtdProdutos, tipoOperacaoOriginalRedirect);
        }
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_AUTO || keyFluxo == transacoesGenericas.KEY_FLUXO_AUTO_CONSULTA_SALDO) {
            ProcessAuto processAuto = this.createProcessAuto(keyFluxo, transacoesGenericas);
            return this.processGenericFluxo(dados, processAuto, qtdProdutos, tipoOperacaoOriginalRedirect);
        }
        logger.error("Keyfluxo n\u00e3o encontrado: " + keyFluxo);
        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.EXEPROTRAGEN_FLUXO_NOT_FOUND, InternacionalizacaoUtil.getInstance().getMessage("EXEPROTRAGEN_FLUXO_NOT_FOUND")));
        return FLUXO_NOT_FOUND_AC;
    }

    private int getQtdProdutos(EntradaApiTefC entradaApiTefC, SaidaApiTefC saida) {
        return entradaApiTefC.getCodigoProduto() != null ? saida.getProdutos().length : 0;
    }

    private int initKeyFluxo(EntradaApiTefC entradaApiTefC, TransacoesGenericas transacoesGenericas) {
        if (entradaApiTefC.getCodigoProduto() != null) {
            return entradaApiTefC.getFluxoTef();
        }
        if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_DEBITO_GENERICO.getDescription())) {
            return transacoesGenericas.KEY_FLUXO_DEBITO;
        }
        if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CREDITO_GENERICO.getDescription())) {
            return transacoesGenericas.KEY_FLUXO_CREDITO;
        }
        if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_DEB_VOUCHER.getDescription())) {
            return transacoesGenericas.KEY_FLUXO_VOUCHER;
        }
        if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CONSULTA_CDC_COM_PARC_AVISTA.getDescription())) {
            return transacoesGenericas.KEY_FLUXO_CONSULTA_CDC;
        }
        if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CREDIARIO_DE_CREDITO.getDescription()) || Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CREDIARIO_DE_DEBITO.getDescription())) {
            return transacoesGenericas.KEY_FLUXO_CREDIARIO;
        }
        if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_SIMULACAO_CREDIARIO_DE_CREDITO.getDescription())) {
            return transacoesGenericas.KEY_FLUXO_CONSULTA_CDC;
        }
        return 0;
    }

    private String getTipoOperacaoCrediario() {
        String tipoOperacaoCrediario = null;
        if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CREDIARIO_DE_CREDITO.getDescription())) {
            tipoOperacaoCrediario = OperationEnum.OP_CREDIARIO_DE_CREDITO.getDescription();
        } else if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CREDIARIO_DE_DEBITO.getDescription())) {
            tipoOperacaoCrediario = OperationEnum.OP_CREDIARIO_DE_DEBITO.getDescription();
        } else if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CREDITO_GENERICO.getDescription())) {
            tipoOperacaoCrediario = OperationEnum.OP_CREDIARIO_DE_CREDITO.getDescription();
        } else if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_DEBITO_GENERICO.getDescription())) {
            tipoOperacaoCrediario = OperationEnum.OP_CREDIARIO_DE_DEBITO.getDescription();
        }
        return tipoOperacaoCrediario;
    }

    private String processGenericFluxo(Process dados, Process processoAhExecutar, int qtdProdutos, String tipoOperacaoOriginalRedirect) throws ExcecaoNaoLocal {
        Contexto.getContexto().setTransacaoGenerica(true);
        if (qtdProdutos > 1) {
            Contexto.getContexto().setSaidaApiTefC(null);
        }
        processoAhExecutar.setParent(dados);
        ProcessManager.getInstance().subProcess(dados.getIdProcess(), processoAhExecutar);
        dados.setErro(processoAhExecutar.getErro());
        this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
        if (processoAhExecutar.getState() == 1) {
            return ERROR;
        }
        if (processoAhExecutar.getState() == 4) {
            Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
            return REDIRECT;
        }
        return SUCCESS;
    }

    private String processKeyFluxoAvs(Process dados, String tipoOperacaoOriginalRedirect) throws ExcecaoNaoLocal {
        ProcessConsultaAvs processConsultaAvs = this.createProcessConsultaAvs();
        Contexto.getContexto().setSaidaApiTefC(null);
        processConsultaAvs.setParent(dados);
        ProcessManager.getInstance().subProcess(dados.getIdProcess(), processConsultaAvs);
        Contexto.getContexto().setOperacao(OperationEnum.OP_CONSULTA_AVS.getKey());
        this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
        if (processConsultaAvs.getState() == 1) {
            return ERROR;
        }
        if (processConsultaAvs.getState() == 4) {
            Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
            return REDIRECT;
        }
        return SUCCESS;
    }

    private String processKeyFluxoCreditoPrivateLabel(Process dados, String tipoOperacaoOriginalRedirect) throws ExcecaoNaoLocal {
        ProcessCreditoPrivateLabel processCreditoPrivateLabel = this.createProcessCreditoPrivateLabel();
        Contexto.getContexto().setTipoOperacao(OperationEnum.OP_CRED_PRIVATE_LABEL.getDescription());
        Contexto.getContexto().setSaidaApiTefC(null);
        Contexto.getContexto().setTransacaoGenerica(true);
        processCreditoPrivateLabel.setParent(dados);
        ProcessManager.getInstance().subProcess(dados.getIdProcess(), processCreditoPrivateLabel);
        dados.setErro(processCreditoPrivateLabel.getErro());
        this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
        if (processCreditoPrivateLabel.getState() == 1) {
            return ERROR;
        }
        if (processCreditoPrivateLabel.getState() == 4) {
            Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
            return REDIRECT;
        }
        return SUCCESS;
    }

    private String processKeyFluxoPlataformaPromocional(Process dados, String tipoOperacaoOriginalRedirect) throws ExcecaoNaoLocal {
        ProcessResgatePremio processResgatePremio = this.createProcessResgatePremio();
        Contexto.getContexto().setSaidaApiTefC(null);
        processResgatePremio.setParent(dados);
        ProcessManager.getInstance().subProcess(dados.getIdProcess(), processResgatePremio);
        dados.setErro(processResgatePremio.getErro());
        Contexto.getContexto().setOperacao(OperationEnum.OP_RESGATE_PREMIO.getKey());
        this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
        if (processResgatePremio.getState() == 1) {
            return ERROR;
        }
        if (processResgatePremio.getState() == 4) {
            Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
            return REDIRECT;
        }
        return SUCCESS;
    }

    private String processKeyConvenioCombustivel(Process dados) throws ExcecaoNaoLocal {
        String tipoOperacaoOriginalRedirect = Contexto.getContexto().getTipoOperacao();
        ProcessConvenioCombustivel processConvenioCombustivel = this.createProcessConvenioCombustivel();
        processConvenioCombustivel.setPerifericos(dados.getPerifericos());
        processConvenioCombustivel.setParent(dados);
        ProcessManager.getInstance().subProcess(dados.getIdProcess(), processConvenioCombustivel);
        dados.setErro(processConvenioCombustivel.getErro());
        this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
        if (processConvenioCombustivel.getState() == 1) {
            return ERROR;
        }
        if (processConvenioCombustivel.getState() == 4) {
            Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
            return REDIRECT;
        }
        return SUCCESS;
    }

    private void preencheDadosRetorno1F(SaidaApiTefC saidaApiTefC) {
        if (saidaApiTefC != null) {
            if (Contexto.getContexto().getDataAutorizadora() == null) {
                Contexto.getContexto().setDataAutorizadora(saidaApiTefC.getDataAutorizadora());
            }
            if (!VerifyContentUtil.verificaConteudoVazio(saidaApiTefC.getCodigoVan())) {
                Contexto.getContexto().setCodigoVan(saidaApiTefC.getCodigoVan());
            }
            if (!VerifyContentUtil.verificaConteudoVazio(saidaApiTefC.getNomeVan())) {
                Contexto.getContexto().setNomeVan(saidaApiTefC.getNomeVan());
            }
            if (!VerifyContentUtil.verificaConteudoVazioCodigoAutorizadora(saidaApiTefC.getCodigoAutorizadora())) {
                Contexto.getContexto().setCodigoAutorizadora(saidaApiTefC.getCodigoAutorizadora());
            }
            if (!VerifyContentUtil.verificaConteudoVazio(saidaApiTefC.getNomeAutorizadora())) {
                Contexto.getContexto().setNomeAutorizadora(saidaApiTefC.getNomeAutorizadora());
            }
            if (!VerifyContentUtil.verificaConteudoVazio(saidaApiTefC.getCodigoInstituicaoFinanceira())) {
                Contexto.getContexto().setCodigoInstituicaoFinanceira(saidaApiTefC.getCodigoInstituicaoFinanceira());
            }
            if (!VerifyContentUtil.verificaConteudoVazio(saidaApiTefC.getNomeInstituicaoFinanceira())) {
                Contexto.getContexto().setNomeInstituicaoFinanceira(saidaApiTefC.getNomeInstituicaoFinanceira());
            }
        }
    }

    protected ProcessDebito createProcessDebito() {
        return new ProcessDebito(this.processConstructorArguments);
    }

    protected ProcessCredito createProcessCredito() {
        return new ProcessCredito(this.processConstructorArguments);
    }

    protected ProcessVoucher createProcessVoucher() {
        return new ProcessVoucher(this.processConstructorArguments);
    }

    protected Process createProcessConsulta(String tipoOperacaoConsultaCDC) {
        if (Contexto.getContexto().getSaidaApiTefC().getMinParcelas() == null) {
            return new ProcessConsultaCDC(this.processConstructorArguments, tipoOperacaoConsultaCDC);
        }
        return new ProcessSimulacaoCrediarioCredito(this.processConstructorArguments);
    }

    protected ProcessPreAutorizacao createProcessPreAutorizacao() {
        return new ProcessPreAutorizacao(this.processConstructorArguments);
    }

    protected ProcessPagamentoContas createProcessPagamentoContas() {
        return new ProcessPagamentoContas(this.processConstructorArguments);
    }

    protected ProcessConsultaAvs createProcessConsultaAvs() {
        return new ProcessConsultaAvs(this.processConstructorArguments);
    }

    protected ProcessCreditoPrivateLabel createProcessCreditoPrivateLabel() {
        return new ProcessCreditoPrivateLabel(this.processConstructorArguments);
    }

    protected ProcessResgatePremio createProcessResgatePremio() {
        return new ProcessResgatePremio(this.processConstructorArguments);
    }

    protected ProcessFuelControl createProcessFuelControl() {
        return new ProcessFuelControl(this.processConstructorArguments);
    }

    protected ProcessCrediario createProcessCrediario() {
        return new ProcessCrediario(this.processConstructorArguments);
    }

    protected ProcessAtualizacaoChip createProcessAtualizacaoChip() {
        return new ProcessAtualizacaoChip(this.processConstructorArguments);
    }

    protected ProcessConvenioCombustivel createProcessConvenioCombustivel() {
        return new ProcessConvenioCombustivel(this.processConstructorArguments, Contexto.getContexto().getEntradaIntegracao(), OperationEnum.OP_CONVENIO_COMBUSTIVEL_AUTORIZACAO.getDescription());
    }

    protected ProcessAuto createProcessAuto(int keyFluxo, TransacoesGenericas transacoesGenericas) {
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_AUTO) {
            return new ProcessAuto(this.processConstructorArguments, OperationEnum.OP_AUTO.getDescription());
        }
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_AUTO_CONSULTA_SALDO) {
            return new ProcessAuto(this.processConstructorArguments, OperationEnum.OP_AUTO_CONSULTA_SALDO.getDescription());
        }
        return new ProcessAuto(this.processConstructorArguments, null);
    }
}

