/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiCtf;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.util.MascaraCartaoUtil;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MicExibeDadosCancelamento {
    public static final String SUCESS = "SUCESS";
    public static final String ABORT = "ABORT";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        BigDecimal valorCancelamento;
        String valorVendaFormatado;
        boolean multiTerminal;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        boolean bl = multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
        if (multiTerminal || !confCTFClient.isConfirmaCancelamento()) {
            return SUCESS;
        }
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        int nsuTransacao = entradaApiTefC.getNsuCtfTransacaoOriginal();
        String nsuTransacaoFormatado = StringUtil.completaString(String.valueOf(nsuTransacao), 6, '0', 3);
        Date dataTransacao = entradaApiTefC.getDataTransacao();
        ControladorPerifericos periferico = dados.getPerifericos();
        DecimalFormat format = new DecimalFormat("#,##0.00");
        if (entradaApiTefC.getOperacao() == ConstantesApiCtf.CONSULTA_QR_CODE.getValue()) {
            BigDecimal valorVenda = entradaApiTefC.getValorTransacao();
            valorVendaFormatado = format.format(valorVenda.doubleValue());
            valorCancelamento = entradaApiTefC.getValorTransacao();
        } else {
            BigDecimal valorVenda = saida.getValorTransacao();
            valorVendaFormatado = format.format(valorVenda.doubleValue());
            valorCancelamento = entradaApiTefC.getValorCancelamento();
        }
        String valorCancelamentoFormatado = format.format(valorCancelamento.doubleValue());
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        LayoutDisplay displayModel = new LayoutDisplay(2);
        displayModel.addLinha(new Linha(inter.getMessage("EXIDADCAN_DADOS_OPERACAO")));
        int formatoCartao = 0;
        formatoCartao = saida.getCodigoVan() == 68 || saida.getCodigoVan() == 90 || saida.getCodigoVan() == 37 || saida.getCodigoVanAlfa() != null && saida.getCodigoVanAlfa().equals("AA") ? 2 : 1;
        if (KeyFactory.isChaveLocal()) {
            if (Contexto.getContexto().getCartao() != null) {
                displayModel.addLinha(new Linha("CARTAO: " + MascaraCartaoUtil.getNumeroMascara(entradaApiTefC.getPAN(), formatoCartao), 0, 1));
            } else if (saida.getNumeroCartao() != null && !saida.getNumeroCartao().equals("")) {
                String numeroCartao = saida.getNumeroCartao();
                String cartaoMascara = MascaraCartaoUtil.getNumeroMascara(numeroCartao, formatoCartao);
                displayModel.addLinha(new Linha("CARTAO: " + cartaoMascara, 0, 1));
            }
        } else if (saida.getPanMascarado() != null) {
            displayModel.addLinha(new Linha("CARTAO: " + MascaraCartaoUtil.getNumeroMascara(saida.getPanMascarado(), formatoCartao), 0, 1));
        }
        displayModel.addLinha(new Linha("DATA: " + dateFormat.format(dataTransacao)));
        displayModel.addLinha(new Linha("VALOR VENDA: " + valorVendaFormatado));
        displayModel.addLinha(new Linha("VALOR A CANC: " + valorCancelamentoFormatado));
        displayModel.addLinha(new Linha("DOC: " + nsuTransacaoFormatado));
        EventoTeclado eventoTeclado = (EventoTeclado)periferico.confirmaDado(displayModel);
        if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
            return SUCESS;
        }
        if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            return ABORT;
        }
        return SUCESS;
    }
}

