/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CorrespondenteBancario;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MicExibeDadosConsultaCorrespondenteBancario {
    public static final String SUCCESS = "SUCCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        EventoTeclado eventoTeclado;
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (saida == null || !saida.isConfirmaDadosConsultaCorban()) {
            return UNECESSARY;
        }
        BigDecimal valorDocumentoAtual = null;
        if (saida.getValorTransacao() != null && saida.getValorTransacao().doubleValue() > 0.0) {
            valorDocumentoAtual = saida.getValorTransacao();
            if (saida.isValorTotalJaCalculado()) {
                logger.info("Calculando o valor do documento a partir do valor do CTF, valorTransacao: " + valorDocumentoAtual);
                if (saida.getValorDesconto() != null) {
                    valorDocumentoAtual = valorDocumentoAtual.add(saida.getValorDesconto());
                    logger.info("desconto: " + saida.getValorDesconto());
                }
                if (saida.getValorAcrescimo() != null) {
                    valorDocumentoAtual = valorDocumentoAtual.subtract(saida.getValorAcrescimo());
                    logger.info("acr\u00e9scimo: " + saida.getValorAcrescimo());
                }
            }
            logger.info("Valor do documento calculado: " + valorDocumentoAtual);
        } else if (entrada.getValorDocumento() != null) {
            valorDocumentoAtual = entrada.getValorDocumento();
        }
        logger.info("Confirma\u00e7\u00e3o dos dados utilizando o display do operador");
        ControladorPerifericos periferico = dados.getPerifericos();
        DecimalFormat format = new DecimalFormat("#,##0.00");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        LayoutDisplay displayModel = new LayoutDisplay(2);
        displayModel.addLinha(new Linha(inter.getMessage("EXIDADCONCORBAN_TITLE")));
        String linha1CodigoBarras = null;
        String linha2CodigoBarras = null;
        String codigoBarras = entrada.getCodigoBarras();
        if (codigoBarras != null) {
            if (Contexto.getContexto().getTipoConta() == 1) {
                int posInicio = 0;
                String cod1 = "";
                String cod2 = "";
                if (entrada.getModoEntradaCodigoBarras() == 1) {
                    cod1 = cod1 + codigoBarras.substring(posInicio, posInicio + 5) + "." + codigoBarras.substring(posInicio + 5, posInicio + 10) + " ";
                    cod1 = cod1 + codigoBarras.substring(posInicio += 10, posInicio + 5) + "." + codigoBarras.substring(posInicio + 5, posInicio + 11);
                    cod2 = cod2 + codigoBarras.substring(posInicio += 11, posInicio + 5) + "." + codigoBarras.substring(posInicio + 5, posInicio + 11) + " ";
                    cod2 = cod2 + codigoBarras.substring(posInicio += 11, posInicio + 1) + " ";
                    cod2 = cod2 + codigoBarras.substring(++posInicio, posInicio + 14);
                    linha1CodigoBarras = cod1;
                    linha2CodigoBarras = cod2;
                } else if (entrada.getModoEntradaCodigoBarras() == 3 || entrada.getModoEntradaCodigoBarras() == 3) {
                    String banco = codigoBarras.substring(posInicio, posInicio + 3);
                    String moeda = codigoBarras.substring(posInicio += 3, posInicio + 1);
                    String digito = codigoBarras.substring(++posInicio, posInicio + 1);
                    String fator = codigoBarras.substring(++posInicio, posInicio + 4);
                    String valor = codigoBarras.substring(posInicio += 4, posInicio + 10);
                    String campoLivre1 = codigoBarras.substring(posInicio += 10, posInicio + 5);
                    String campoLivre2 = codigoBarras.substring(posInicio += 5, posInicio + 10);
                    String campoLivre3 = codigoBarras.substring(posInicio += 10, posInicio + 10);
                    posInicio += 10;
                    cod1 = banco + moeda + campoLivre1.substring(0, 1) + "." + campoLivre1.substring(1, campoLivre1.length()) + "X " + campoLivre2.substring(0, 5) + "." + campoLivre2.substring(5, campoLivre2.length()) + "X";
                    cod2 = campoLivre3 + "X " + digito + " " + fator + valor;
                    linha1CodigoBarras = cod1;
                    linha2CodigoBarras = cod2;
                }
            } else if (Contexto.getContexto().getTipoConta() == 2) {
                int tamanhoBloco = codigoBarras.length() == 48 ? 12 : 11;
                int posInicio = 0;
                String cod1 = "";
                String cod2 = "";
                cod1 = cod1 + codigoBarras.substring(posInicio, posInicio + tamanhoBloco) + " ";
                cod1 = cod1 + codigoBarras.substring(posInicio += tamanhoBloco, posInicio + tamanhoBloco);
                cod2 = cod2 + codigoBarras.substring(posInicio += tamanhoBloco, posInicio + tamanhoBloco) + " ";
                cod2 = cod2 + codigoBarras.substring(posInicio += tamanhoBloco, posInicio + tamanhoBloco);
                linha1CodigoBarras = cod1;
                linha2CodigoBarras = cod2;
            }
        }
        String cedente = null;
        CorrespondenteBancario corban = Contexto.getContexto().getCorrespondenteBancario();
        if (corban != null && corban.getCedente() != null && corban.getCedente().length() > 0) {
            cedente = corban.getCedente().trim();
        }
        String valorDocumentoFormatado = null;
        if (valorDocumentoAtual != null) {
            valorDocumentoFormatado = format.format(valorDocumentoAtual.doubleValue());
        }
        Date dataVencimento = entrada.getDataVencimentoCorBan();
        String valorDescontoFormatado = null;
        BigDecimal valorDesconto = null;
        valorDesconto = saida.getValorDesconto() != null ? saida.getValorDesconto() : new BigDecimal(0);
        valorDescontoFormatado = format.format(valorDesconto.doubleValue());
        String valorAcrescimoFormatado = null;
        BigDecimal valorAcrescimo = null;
        valorAcrescimo = saida.getValorAcrescimo() != null ? saida.getValorAcrescimo() : new BigDecimal(0);
        valorAcrescimoFormatado = format.format(valorAcrescimo.doubleValue());
        if (linha1CodigoBarras != null && linha2CodigoBarras != null && !linha1CodigoBarras.equals("") && !linha2CodigoBarras.equals("")) {
            displayModel.addLinha(new Linha("CODIGO DE BARRAS:"));
            displayModel.addLinha(new Linha(" " + linha1CodigoBarras));
            displayModel.addLinha(new Linha(" " + linha2CodigoBarras));
        }
        if (cedente != null) {
            displayModel.addLinha(new Linha("CEDENTE: "));
            displayModel.addLinha(new Linha(" " + cedente));
        }
        displayModel.addLinha(new Linha("DATA:  " + dateFormat.format(dataVencimento)));
        if (valorDocumentoFormatado != null) {
            displayModel.addLinha(new Linha("VALOR DOCUMENTO:  " + this.completaEspacosNumero(valorDocumentoFormatado)));
        }
        if (valorDesconto.compareTo(new BigDecimal(0)) != 0) {
            displayModel.addLinha(new Linha("VALOR DESCONTOS:  " + this.completaEspacosNumero(valorDescontoFormatado)));
        }
        if (valorAcrescimo.compareTo(new BigDecimal(0)) != 0) {
            displayModel.addLinha(new Linha("VALOR ACRESCIMOS: " + this.completaEspacosNumero(valorAcrescimoFormatado)));
        }
        if ((eventoTeclado = (EventoTeclado)periferico.confirmaDado(displayModel)).getTeclaFinalizadora().equals("ENTRA")) {
            return SUCCESS;
        }
        if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            return USER_CANCEL;
        }
        return SUCCESS;
    }

    private String completaEspacosNumero(String valor) {
        int digitos = 8;
        String valorFormatado = valor.length() < digitos ? StringUtil.completaString(valor, digitos, ' ', 3) : valor;
        return valorFormatado;
    }
}

