/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.AmountType;
import com.csi.ctfclient.apitef.ApitefStringUtil;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.ProdutoResgateBrPremmia;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.excecoes.InvalidDataException;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicExibeMenuProdutosPremmia;
import com.csi.ctfclient.servicos.CTFClientCore;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class MicExibeProdutosPremmiaGenerico {
    public static final String SUCCESS = "SUCCESS";
    public static final String SUCCESS_CAPTURE_VALUE = "SUCESSO_CAPTURA_VALOR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_SELECTION_MENU = "USER_CANCEL_SELECTION_MENU";
    public static final String INVALID_INPUT = "ENTRADA_INVALIDA";
    public static final String INVALID_CTF_DATA = "DADOS_CTF_INVALIDO";
    public static final String ERROR = "ERROR";
    public static final String EMPTY_LIST = "LISTA_VAZIA";
    protected static final String PONTOS = "P";
    protected static final String VALE_COMBUSTIVEL = "V";
    protected static final String SIGA_BEM = "S";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    protected abstract List<ProdutoResgateBrPremmia> buildProductList(String var1) throws InvalidDataException;

    protected abstract String buildProductsTitle();

    public String execute(Process parent) throws ExcecaoNaoLocal {
        int selectedProductIndex;
        List<ProdutoResgateBrPremmia> products;
        SaidaApiTefC ctfOut = Contexto.getContexto().getSaidaApiTefC();
        if (ctfOut.getProductList() == null) {
            return EMPTY_LIST;
        }
        logger.debug("Lista de produtos BR Premmia: " + ctfOut.getProductList());
        try {
            products = this.buildProductList(ctfOut.getProductList());
            logger.debug("Quantidade de produtos = " + products.size());
            if (products.isEmpty()) {
                return ERROR;
            }
            List<String> descriptions = this.buildDescriptionList(products);
            selectedProductIndex = parent.getPerifericos().showSingleChoiceMenu(parent, this.buildProductsTitle(), descriptions);
            logger.debug("\u00cdndice de produto selecionado = " + selectedProductIndex);
            if (selectedProductIndex == -1) {
                logger.info("Sele\u00e7\u00e3o de produto cancelada pelo usu\u00e1rio");
                if (MicExibeMenuProdutosPremmia.containsPointsProducts(ctfOut.getProductList()) && MicExibeMenuProdutosPremmia.containsValueProducts(ctfOut.getProductList())) {
                    return USER_CANCEL_SELECTION_MENU;
                }
                return USER_CANCEL;
            }
            if (selectedProductIndex >= descriptions.size()) {
                logger.info("Entrada do usu\u00e1rio fora do limite");
                return INVALID_INPUT;
            }
        }
        catch (InvalidDataException e) {
            logger.error("Erro ao montar a lista de produtos: " + e.getMessage());
            return ERROR;
        }
        ProdutoResgateBrPremmia selectedProduct = products.get(selectedProductIndex);
        try {
            logger.debug("Usando como entrada para o CTF: valor=" + selectedProduct.getValue() + ", c\u00f3digo do produto = " + selectedProduct.getCode() + ", tipo do produto = " + selectedProduct.getType());
            EntradaApiTefC ctfIn = Contexto.getContexto().getEntradaApiTefC();
            ctfIn.setCodigoProduto(Integer.valueOf(selectedProduct.getCode()));
            if (VALE_COMBUSTIVEL.equals(selectedProduct.getType())) {
                return SUCCESS_CAPTURE_VALUE;
            }
            if (SIGA_BEM.equals(selectedProduct.getType())) {
                Contexto.getContexto().setTrnAmountType(AmountType.POINTS);
            }
            ctfIn.setValorTransacao(new BigDecimal(selectedProduct.getValue()));
            return SUCCESS;
        }
        catch (Exception e) {
            logger.error("Dados inv\u00e1lidos de produtos BR Premmia vindos do CTF: " + e.getMessage());
            return INVALID_CTF_DATA;
        }
    }

    protected List<ProdutoResgateBrPremmia> buildProductListFor(String list, List<String> types) throws InvalidDataException {
        ArrayList<ProdutoResgateBrPremmia> ret = new ArrayList<ProdutoResgateBrPremmia>();
        List<String> products = ApitefStringUtil.stringApiTefToList(list);
        for (String productData : products) {
            try {
                ProdutoResgateBrPremmia product = new ProdutoResgateBrPremmia();
                product.parse(productData);
                if (!types.contains(product.getType())) continue;
                ret.add(product);
            }
            catch (Exception e) {
                logger.error("Falha ao fazer a interpreta\u00e7\u00e3o da lista de produtos BR Premmia: " + e.getMessage());
                throw new InvalidDataException(list);
            }
        }
        Collections.sort(ret, this.buildComparator());
        return ret;
    }

    List<String> buildDescriptionList(List<ProdutoResgateBrPremmia> products) {
        ArrayList<String> ret = new ArrayList<String>();
        for (ProdutoResgateBrPremmia p : products) {
            ret.add(p.getDescription());
        }
        return ret;
    }

    Comparator<ProdutoResgateBrPremmia> buildComparator() {
        return new Comparator<ProdutoResgateBrPremmia>(){

            @Override
            public int compare(ProdutoResgateBrPremmia left, ProdutoResgateBrPremmia right) {
                int rightIndex;
                int leftIndex = Integer.parseInt(left.getIndex());
                if (leftIndex > (rightIndex = Integer.parseInt(right.getIndex()))) {
                    return 1;
                }
                if (leftIndex < rightIndex) {
                    return -1;
                }
                return 0;
            }
        };
    }
}

