/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;
import com.csi.ctfclient.tools.devices.fusion.DadosListaPreset;
import com.csi.ctfclient.tools.devices.fusion.Preset;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;

public class MicExibeStatusBombasCombustivel {
    public static String SUCCESS = "SUCCESS";
    public static String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private String[] statusPreset = new String[]{"AUTORIZADO", "ABASTECENDO", "BLOQUEADO", "PRONTO"};

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENVIO1F_TITLE"));
        dados.getPerifericos().imprimeDisplay(displayModel);
        ControladorFusion fusion = ControladorFusion.getInstancia();
        ControladorPerifericos perifericos = dados.getPerifericos();
        DadosListaPreset dadosListaPreset = null;
        try {
            dadosListaPreset = fusion.listarPresets();
        }
        catch (Exception e) {
            logger.warn("Erro ao tentar ler dados da lista de predefinicoes: " + e.getMessage());
        }
        if (dadosListaPreset == null || dadosListaPreset.getResultado() != 0) {
            if (dadosListaPreset != null) {
                logger.error("Erro ao ler o status das bombas, c\u00f3digo: " + dadosListaPreset.getResultado());
            }
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_CONEXAO_FUSION, "ERRO CONEXAO FUSION"));
            return ERROR;
        }
        LayoutDisplay layoutDisplay = new LayoutDisplay(2);
        layoutDisplay.addLinha(new Linha("ANDAMENTO DO ABASTECIMENTO"));
        List<Preset> listPreset = dadosListaPreset.getListPreset();
        Iterator<Preset> itePreset = listPreset.iterator();
        DecimalFormat format2Zeros = new DecimalFormat("00");
        DecimalFormat formatVolume = new DecimalFormat("#,##0.000");
        if (listPreset.size() > 0) {
            while (itePreset.hasNext()) {
                Preset preset = itePreset.next();
                String status = "";
                if (preset.getStatusPreset() >= 1 && preset.getStatusPreset() <= 4) {
                    status = StringUtil.completaString(this.statusPreset[preset.getStatusPreset() - 1], 11, ' ', 4);
                }
                String volumeAbastecimento = "";
                if (preset.getVolumeAbastecido() != null && preset.getVolumeAbastecido().compareTo(new BigDecimal(0)) == 1) {
                    volumeAbastecimento = formatVolume.format(preset.getVolumeAbastecido()) + " L";
                }
                String linha = format2Zeros.format(preset.getProduto().getBomba().getId()) + " - " + status + " " + volumeAbastecimento;
                layoutDisplay.addLinha(new ItemMenu(linha));
            }
        } else {
            layoutDisplay.addLinha(new Linha("SEM INFORMACOES DISPONIVEIS"));
        }
        perifericos.confirmaDado(layoutDisplay);
        return SUCCESS;
    }
}

