/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;
import com.csi.ctfclient.tools.devices.fusion.StatusFusion;
import com.csi.ctfclient.tools.util.CriptografiaUtil;

public class MicFinalizarPresetConvenioCombustivel {
    public static String SUCCESS_APROVADA = "SUCCESS_APROVADA";
    public static String SUCCESS_NEGADA = "SUCCESS_NEGADA";
    public static String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) {
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        String hashCartao = Contexto.getContexto().getHashCartao() != null ? Contexto.getContexto().getHashCartao() : CriptografiaUtil.gerarHash(Contexto.getContexto().getEntradaApiTefC().getPAN(), "SHA-256");
        ControladorFusion fusion = ControladorFusion.getInstancia();
        StatusFusion statusFusion = null;
        try {
            if (saida != null && saida.getRetorno() == 0) {
                logger.info("Transa\u00e7\u00e3o aprovada, confirmando preset...");
                statusFusion = fusion.finalizarPreset(hashCartao);
            }
        }
        catch (Exception e) {
            logger.warn("Erro ao definir o status do fusion: " + e.getMessage());
        }
        if (statusFusion == null || statusFusion.getResultado() != 0) {
            if (statusFusion != null) {
                logger.error("Erro ao finalizar o preset, c\u00f3digo: " + statusFusion.getResultado());
            }
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_CONEXAO_FUSION, "ERRO CONEXAO FUSION"));
            return ERROR;
        }
        if (saida != null && saida.getRetorno() == 0) {
            return SUCCESS_APROVADA;
        }
        return SUCCESS_NEGADA;
    }
}

