/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.RemoveCardMessage;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaFinishChipEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.StringUtil;

public class MicFinishChip
extends MicAbstractBase {
    public static final String SUCESS_APROVADA = "SUCESS_APROVADA";
    public static final String SUCCESS_APROVADA_OFF = "SUCCESS_APROVADA_OFF";
    public static final String SUCESS_NEGADA_CARTAO = "SUCESS_NEGADA_CARTAO";
    public static final String NEGADA_CARTAO_OFF = "NEGADA_CARTAO_OFF";
    public static final String SUCESS_NEGADA_HOST = "SUCESS_NEGADA_HOST";
    public static final String SUCCESS_NEGADA_HOST_REENVIO = "SUCCESS_NEGADA_HOST_REENVIO";
    public static final String NOTREQUIRED = "NOTREQUIRED";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String ERRO = "ERRO";
    public static final String ERRO_PIN_PAD = "ERRO_PIN_PAD";
    public static final String ERRO_FINISH_CHIP = "ERRO_FINISH_CHIP";
    public static final int DECISION_REJECT_BY_HOST = 2;
    public static final int DECISION_REJECT_BY_CARD = 1;
    public static final int DECISION_APROVED = 0;

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        PinEMV pinEMV;
        ControladorPerifericos perifericos = dados.getPerifericos();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (!saidaApiTefC.isCapturaDadosChip() || saidaApiTefC.isFluxoEMVSemFinishChip() || Contexto.getContexto().getPinInfo() == null) {
            return NOTREQUIRED;
        }
        if (Contexto.getContexto().getPinInfo().getDecisaoTomada() == '1') {
            Contexto.getContexto().setRemoveCardMessage(RemoveCardMessage.MSG_TRANS_NAO_AUT_CARTAO);
            return UNECESSARY;
        }
        try {
            pinEMV = perifericos.getPin();
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.error("Nao foi possivel carregar o pinpad: " + excecaoPerifericos.getMessage());
            return ERRO;
        }
        if (saidaApiTefC.getRetorno() == 0 || saidaApiTefC.getRetorno() == 1 || saidaApiTefC.getRetorno() == 5 || saidaApiTefC.getRetorno() != 11 && saidaApiTefC.getStatusComunicacao() != 0) {
            if (saidaApiTefC.getStatusComunicacao() == 0) {
                pinEMV.setComunicacaoHost(saidaApiTefC.getStatusComunicacao());
                pinEMV.setTipoEmissor(saidaApiTefC.getTipoEmissor());
                if (saidaApiTefC.getCardIssuerResponseCode() != null) {
                    pinEMV.setAuthRespCode(saidaApiTefC.getCardIssuerResponseCode());
                } else {
                    pinEMV.setAuthRespCode(saidaApiTefC.getCodigoRespostaAutorizadora());
                }
                pinEMV.setCampo55(saidaApiTefC.getDadosRespostaChip());
                pinEMV.setDadosRestantes("");
                pinEMV.setTags(saidaApiTefC.getTagsFinais());
            } else {
                pinEMV.setComunicacaoHost(1);
                pinEMV.setTipoEmissor(0);
                pinEMV.setAuthRespCode("00");
                pinEMV.setCampo55("");
                pinEMV.setDadosRestantes("");
                pinEMV.setTags(Contexto.getContexto().getTagsMandatorias());
            }
        } else {
            return UNECESSARY;
        }
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        try {
            SaidaFinishChipEMV chipEMV = pinEMV.finishChip();
            if (chipEMV.getRetorno() > 2) {
                Contexto.getContexto().setRemoveCardMessage(chipEMV.getRetorno() + " - ERRO PIN PAD");
                return ERRO_PIN_PAD;
            }
            int decision = chipEMV.getDecisao();
            if (((BibliotecaPinpad)pinEMV).isPinpadAbecs() && decision > 0) {
                decision = this.decisionAbecs(pinEMV.getComunicacaoHost());
            }
            this.logger.debug("Decis\u00e3o FinishiChip: " + decision);
            Contexto.getContexto().getPinInfo().setDecisaoFinishChip(decision);
            if (pinEMV.getComunicacaoHost() == 1) {
                entrada.setDadosFinaisChip(chipEMV.getDadosFinais());
                entrada.setDecisaoChip(StringUtil.completaString(decision + "", 1, ' ', 3).toCharArray()[0]);
                entrada.setStatusComunicacaoHost(pinEMV.getComunicacaoHost());
                entrada.setDadosChip(null);
            }
            switch (decision) {
                case 0: {
                    entrada.setDadosFinaisChip(chipEMV.getDadosFinais());
                    entrada.setIssuerScriptResult(chipEMV.getIssuerScriptResults());
                    Contexto.getContexto().setRemoveCardMessage(RemoveCardMessage.MSG_TRANS_APROVADA);
                    if (pinEMV.getComunicacaoHost() == 1) {
                        return SUCCESS_APROVADA_OFF;
                    }
                    return SUCESS_APROVADA;
                }
                case 1: {
                    entrada.setTipoResposta('2');
                    entrada.setDadosFinaisChip(chipEMV.getDadosFinais());
                    entrada.setIssuerScriptResult(chipEMV.getIssuerScriptResults());
                    if (pinEMV.getComunicacaoHost() == 1) {
                        entrada.setStatusComunicacaoHost(pinEMV.getComunicacaoHost());
                    }
                    int redeChip = Integer.parseInt(entrada.getCodigoRedeAdquirenteChip());
                    if (saidaApiTefC.getRetorno() != 5 && saidaApiTefC.getRetorno() != 1) {
                        if (redeChip == 2) {
                            Contexto.getContexto().setFinishChipMessage("TRANSACAO NEGADA LIGUE EMISSOR");
                        } else {
                            Contexto.getContexto().setFinishChipMessage("TRANS. NAO AUT. PELO CARTAO");
                        }
                    }
                    if (redeChip == 2) {
                        Contexto.getContexto().setRemoveCardMessage(RemoveCardMessage.REMCAR_TRANS_NAO_AUT_CARTAO_LIGUE_EMISSOR);
                    } else {
                        Contexto.getContexto().setRemoveCardMessage(RemoveCardMessage.MSG_TRANS_NAO_AUT_CARTAO);
                    }
                    entrada.setMotivoDesfazimento(2);
                    if (pinEMV.getComunicacaoHost() == 1) {
                        if (entrada.getCodigoRedeAdquirenteChip().equals("03")) {
                            Contexto.getContexto().setRemoveCardMessage("TENTE DE NOVO-TO");
                        }
                        return NEGADA_CARTAO_OFF;
                    }
                    return SUCESS_NEGADA_CARTAO;
                }
                case 2: {
                    if (saidaApiTefC.getMensagemDisplayPin().trim().equals("")) {
                        Contexto.getContexto().setRemoveCardMessage(RemoveCardMessage.MSG_TRANS_NAO_APROV);
                    }
                    if (saidaApiTefC.isReenvioNegadaHost() && (chipEMV.getDadosFinais() != null && chipEMV.getDadosFinais().length() > 0 || chipEMV.getIssuerScriptResults() != null && chipEMV.getIssuerScriptResults().length() > 0)) {
                        entrada.setDadosFinaisChip(chipEMV.getDadosFinais());
                        entrada.setIssuerScriptResult(chipEMV.getIssuerScriptResults());
                        return SUCCESS_NEGADA_HOST_REENVIO;
                    }
                    return SUCESS_NEGADA_HOST;
                }
            }
            return ERRO;
        }
        catch (Exception e) {
            this.logger.error("Erro durante a execucao do finish chip: " + e.getMessage());
            if (e instanceof ExcecaoPerifericos && Contexto.getContexto().getSaidaApiTefC().getRetorno() == 0) {
                ExcecaoPerifericos erroPeriferico = (ExcecaoPerifericos)e;
                Contexto.getContexto().setErrorCode(erroPeriferico.getCodigoErroOriginal());
                entrada.setMotivoDesfazimento(2);
                return ERRO_FINISH_CHIP;
            }
            if (Contexto.getContexto().getErroIntegracao() == null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TENTE_NOVAMENTE, "TENTE NOVAMENTE"));
            }
            return ERRO;
        }
    }

    private int decisionAbecs(int statusCommunication) {
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        return !saidaApiTefC.getCodigoRespostaAutorizadora().equals("00") && !saidaApiTefC.getCodigoRespostaAutorizadora().equals("000") && statusCommunication == 0 ? 2 : 1;
    }
}

