/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.StringUtil;

public class MicFormataIdentificacaoPagamentoFatura
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String ERROR_AC = "ERROR_AC";
    public static final String ERROR = "ERROR";
    public static final int IDENTIFICACAO_PAGAMENTO_FATURA_CODIGO_BARRAS = 1;
    public static final int IDENTIFICACAO_PAGAMENTO_FATURA_CPF = 2;
    public static final int IDENTIFICACAO_PAGAMENTO_FATURA_CARTAO = 3;
    public static final int IDENTIFICACAO_PAGAMENTO_FATURA_OUTROS = 4;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        String identificadorFatura;
        String bufferCriptografar;
        EntradaApiTefC entrada;
        block15: {
            SaidaApiTefC saida;
            block16: {
                block13: {
                    block14: {
                        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
                        entrada = Contexto.getContexto().getEntradaApiTefC();
                        saida = Contexto.getContexto().getSaidaApiTefC();
                        ControladorPerifericos perifericos = dados.getPerifericos();
                        if (entradaIntegracao == null || !entradaIntegracao.isTipoIdentificacaoPagamentoFaturaCtrl()) break block13;
                        if (entradaIntegracao.getTipoIdentificacaoPagamentoFatura() != 1 && entradaIntegracao.getTipoIdentificacaoPagamentoFatura() != 2 && entradaIntegracao.getTipoIdentificacaoPagamentoFatura() != 3 && entradaIntegracao.getTipoIdentificacaoPagamentoFatura() != 4) {
                            this.logger.error("Tipo de identificador inv\u00e1lido");
                            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.IDENTIFICACAO_PAGAMENTO_FATURA_INVALIDO, "TIPO DE IDENTIFICACAO PAGAMENTO FATURA INVALIDO: " + entradaIntegracao.getTipoIdentificacaoPagamentoFatura()));
                            return ERROR_AC;
                        }
                        if (!entradaIntegracao.isIdentificacaoPagamentoFaturaCtrl() || entradaIntegracao.getIdentificacaoPagamentoFatura().length() <= 0) break block14;
                        if (saida.isCriptografiaCartao() && this.tryGetPin() != null) {
                            try {
                                Double.parseDouble(entradaIntegracao.getIdentificacaoPagamentoFatura());
                            }
                            catch (NumberFormatException e) {
                                this.logger.error("Identificador de pagamento n\u00e3o num\u00e9rico");
                                this.logger.info("Identificador fatura: '" + entradaIntegracao.getIdentificacaoPagamentoFatura() + "'");
                                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.IDENTIFICACAO_PAGAMENTO_FATURA_INVALIDO, "IDENTIFICACAO PAGAMENTO FATURA NAO NUMERICO"));
                                return ERROR_AC;
                            }
                        }
                        bufferCriptografar = entradaIntegracao.getIdentificacaoPagamentoFatura();
                        entrada.setTipoIdentificacaoPagamentoFatura(entradaIntegracao.getTipoIdentificacaoPagamentoFatura());
                        if (!saida.isCriptografiaCartao()) break block15;
                        break block16;
                    }
                    this.logger.error("Identificador de pagamento inv\u00e1lido");
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.IDENTIFICACAO_PAGAMENTO_FATURA_INVALIDO, "IDENTIFICACAO PAGAMENTO FATURA INVALIDO"));
                    return ERROR_AC;
                }
                return UNECESSARY;
            }
            if (this.tryGetPin() != null) {
                String buffer16;
                this.logger.info("Criptografar o identificador da fatura");
                String bufferCompletar = "";
                if (bufferCriptografar.length() < 16) {
                    buffer16 = StringUtil.completaString(bufferCriptografar, 16, 'F', 4);
                } else {
                    if (bufferCriptografar.length() > 16) {
                        bufferCompletar = bufferCriptografar.substring(16, bufferCriptografar.length());
                    }
                    buffer16 = bufferCriptografar.substring(0, 16);
                }
                if (ProtocoloBibliotecaCompartilhada.isSecureCommunication()) {
                    try {
                        buffer16 = LeitorCartao.descriptografaPAN(buffer16, false);
                    }
                    catch (Exception e) {
                        this.logger.error("Erro ao descriptografar PAN: " + e.getMessage());
                    }
                }
                try {
                    String cript = this.criptografaDados(dados, buffer16, saida);
                    identificadorFatura = cript + bufferCompletar;
                }
                catch (ExcecaoPerifericos excecaoPerifericos) {
                    this.logger.error("Erro criptografar dados no pin: " + excecaoPerifericos.getMessage());
                    return ERROR;
                }
            }
        }
        this.logger.info("Enviar o identificador da fatura aberto");
        identificadorFatura = bufferCriptografar;
        entrada.setIdentificacaoPagamentoFatura(identificadorFatura);
        return SUCCESS;
    }

    private String criptografaDados(Process dado, String value, SaidaApiTefC saida) throws ExcecaoPerifericos {
        ControladorPerifericos periferico = dado.getPerifericos();
        BibliotecaPinpad pinCompartilhado = (BibliotecaPinpad)periferico.getPin();
        TabelaCriptografia tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
        RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaDadosPrincipal();
        int modoCriptografia = registroCriptografia.getAlgoritmo();
        String workingKey = StringUtil.completaString(registroCriptografia.getWorkingKey().trim(), 32, '0', false);
        int indiceCriptografia = registroCriptografia.getIndiceMasterKey() == 42 ? 0 : registroCriptografia.getIndiceMasterKey();
        this.logger.debug("Criptografia: Indice: " + indiceCriptografia + ", Modo: " + modoCriptografia + ", Working Key: " + workingKey);
        if (modoCriptografia == 0) {
            workingKey = StringUtil.completaString(workingKey, 32, '0', 4);
        }
        return pinCompartilhado.encryptBuffer(modoCriptografia, indiceCriptografia, workingKey, value);
    }
}

