/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.CardApplicationTypeEnum;
import br.com.auttar.model.constants.OperationEnum;
import br.com.auttar.operation.util.TransactionOperationRules;
import com.csi.ctfclient.apitef.model.Aid;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.controller.ControladorAIDsGetCard;
import java.util.ArrayList;
import java.util.List;

public class MicGeraListaAID
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String UNNECESSARY = "UNNECESSARY";
    public static final String ERROR = "ERROR";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        ArrayList<Aid> listAIDs;
        if (TransactionOperationRules.isTypedOperation() || this.tryGetPin() == null) {
            return UNNECESSARY;
        }
        if (Contexto.getContexto().getListAID() != null) {
            this.logger.info("Reutilizando lista AID j\u00e1 definida no contexto");
            return SUCCESS;
        }
        ControladorAIDsGetCard controladorAIDsGetCard = ControladorAIDsGetCard.getInstance(this.getIdentTerminal());
        if (controladorAIDsGetCard.getMapAid() == null) {
            this.logger.error("N\u00e3o foi poss\u00edvel gerar a Lista de AID's. Erro: controladorAIDsGetCard.getMapAid() est\u00e1 nulo!");
            return ERROR;
        }
        CardApplicationTypeEnum tipoAplicacao = this.getCardApplicationType();
        boolean listarTodosPorAID = false;
        if (null == tipoAplicacao) {
            this.logger.info("Aplica\u00e7\u00e3o do cart\u00e3o definida como m\u00faltiplo ou n\u00e3o confirmada");
            listarTodosPorAID = true;
        } else {
            this.logger.info("Cart\u00e3o identificado como aplica\u00e7\u00e3o de " + tipoAplicacao.getDescription());
        }
        if (listarTodosPorAID) {
            listAIDs = new ArrayList();
            for (List<Aid> aid : controladorAIDsGetCard.getMapAid().values()) {
                listAIDs.addAll(aid);
            }
        } else {
            listAIDs = controladorAIDsGetCard.getMapAid().get(tipoAplicacao.getCode());
        }
        Contexto.getContexto().setListAID(listAIDs);
        return SUCCESS;
    }

    private CardApplicationTypeEnum getCardApplicationType() {
        CardApplicationTypeEnum tipoAplicacao = null;
        OperationEnum operacao = OperationEnum.getEnumByDescription(Contexto.getContexto().getTipoOperacao());
        if (operacao != null) {
            tipoAplicacao = operacao.getApplication();
        }
        return tipoAplicacao;
    }
}

