/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;

public class MicHabilitaConsultaDadosEMV {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) {
        if (Contexto.getContexto().getCartao() != Cartao.CHIP && Contexto.getContexto().getCartao() != Cartao.CONTACTLESS_EMV) {
            logger.error("A transa\u00e7\u00e3o atual exige um cart\u00e3o com Chip, com ou sem contato");
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CARTAO_COM_CHIP_REQUERIDO, "CARTAO COM CHIP REQUERIDO"));
            return ERROR;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        try {
            PinEMV pinEMV = perifericos.getPin();
            pinEMV.setReadTagParameters(saida.getRedeChip(), saida.getFuncaoGenericCommand(), saida.getTagsGenericCommand());
            PerifericoEventHandler.setActive(true);
            pinEMV.habilita(4);
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            logger.error("Erro ao habilitar o pin: " + excecaoPerifericos.getMessage());
            return ERROR;
        }
        return SUCCESS;
    }
}

