/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.util.emv.PinpadPasswordMessageFormatter;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.entrada.IleituraGoOnChip;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.AbortPinPadListener;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.ConstantesEMV;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;

public class MicHabilitaGoOnChip
implements ConstantesEMV {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    protected static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(IleituraGoOnChip dados) throws ExcecaoNaoLocal {
        PinEMV pinEMV;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("HAVGOONCHI_TITLE"));
        displayModel.setImagem(LayoutDisplay.imagens.aguarde_senha);
        perifericos.imprimeDisplay(displayModel);
        try {
            pinEMV = perifericos.getPin();
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            logger.error("Nao foi possivel abrir o pinEMV: " + excecaoPerifericos.getMessage());
            return ERRO;
        }
        if (confCTFClient.isIntegracaoDll()) {
            if (perifericos.getEventoNaoEsperadoListener() != null) {
                pinEMV.removeListener(perifericos.getEventoNaoEsperadoListener());
                perifericos.setEventoNaoEsperadoListener(null);
                perifericos.setEventoNaoEsperado(null);
            }
            perifericos.setEventoNaoEsperadoListener(new AbortPinPadListener(perifericos));
            pinEMV.addListener(perifericos.getEventoNaoEsperadoListener());
        }
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        Criptografia cripto = dados.getCriptografia();
        pinEMV.setConstaListaNegra(saida.getListaNegra() == 1);
        pinEMV.setObrigaTransacaoOnline(saida.getConexao() == 1);
        if (entrada.getCodigoRedeAdquirenteChip() != null) {
            pinEMV.setIdRedeAdquirente(Integer.parseInt(entrada.getCodigoRedeAdquirenteChip()));
        }
        BigDecimal valorTotal = dados.getValorTotal() != null ? dados.getValorTotal() : new BigDecimal(0);
        pinEMV.setNovoValorTransacao(valorTotal.movePointRight(2).longValue());
        if (saida.isValorSaqueGoOnChip()) {
            pinEMV.setParcelaValorTransacao(dados.getValorSaque().movePointRight(2).longValue());
        } else {
            pinEMV.setParcelaValorTransacao(0L);
        }
        pinEMV.setTipoCriptografia(cripto.getModoCriptografia());
        pinEMV.setWorkingKey(cripto.getWorkingKey());
        pinEMV.setIndiceMasterKey(cripto.getIndiceMasterKey());
        pinEMV.setGerencRisco(saida.isRisco());
        pinEMV.setTermFloorLimit(saida.getFloorLimit());
        pinEMV.setTargetPercBiasedRandomSelection(saida.getPercentagem());
        pinEMV.setThresholdValueBiasedRandomSelection(saida.getValorLimite());
        pinEMV.setMaxTargetPerc(saida.getMaximaPercentagem());
        pinEMV.setReqPINTabelasServTEF(saida.isSenhaEasy());
        pinEMV.setTags(saida.getTagsMandatorias());
        pinEMV.setTagsOpt(saida.getTagsOpcionais());
        if (saida.getMensagemSenhaPinpad() != null) {
            PinpadPasswordMessageFormatter formatter = new PinpadPasswordMessageFormatter();
            String mensagemPin = formatter.passwordMessage(dados.getValorTotal(), saida.getMensagemSenhaPinpad(), Contexto.getContexto().getTrnAmountType());
            pinEMV.setDadosRestantes(mensagemPin);
        }
        Contexto.getContexto().setTagsMandatorias(saida.getTagsMandatorias());
        PerifericoEventHandler.setActive(true);
        try {
            pinEMV.habilita(1);
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            logger.error("Nao foi possivel habilitar o pinEMV para GoOnChip: " + excecaoPerifericos.getMessage());
            return ERRO;
        }
        return SUCESS;
    }
}

