/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.LeituraCartaoEnum;
import br.com.auttar.model.constants.OperationEnum;
import br.com.auttar.operation.util.TransactionOperationRules;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.model.Aid;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoInteiroInvalido;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.AbortPinPadListener;
import com.csi.ctfclient.tools.devices.ExcecaoBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.ExcecaoComunicacaoSegura;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.util.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;

public class MicHabilitaLeitorCartao
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String CONFIGURA_PINPAD = "CONFIGURA_PINPAD";
    public static final String MSG_SEM_PINPAD = "999 - ERRO CONECTE PINPAD";
    public static final String MSG_ERRO_COMUNICACAO_SEGURA = "ERRO CHAVE";
    private static final int TIPO_APLICACAO_CREDITO = 1;
    private static final int TIPO_APLICACAO_DEBITO = 2;
    private static final int TIPO_APLICACAO_QUALQUER = 99;

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        LeitorCartao leitorCartao;
        ControladorPerifericos perifericos = dados.getPerifericos();
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaCTFClientCtrl = Contexto.getContexto().getEntradaIntegracao();
        OperationEnum operationEnum = OperationEnum.getEnumByKey(entradaCTFClientCtrl.getOperacao());
        boolean deliveryInternet = entradaApiTefC.getIdentificacaoTransacao() == 1 || entradaApiTefC.getIdentificacaoTransacao() == 2;
        boolean typedOperation = TransactionOperationRules.isTypedOperation();
        ILeitorCartaoHandler cardReaderHandler = this.tryGetCardReader();
        if (deliveryInternet || typedOperation || cardReaderHandler == null) {
            return UNECESSARY;
        }
        LayoutDisplay displayModel = new LayoutDisplay("AGUARDE...");
        displayModel.setImagem(LayoutDisplay.imagens.aguarde_pinpad);
        perifericos.imprimeDisplay(displayModel);
        if (confCTFClient.isIntegracaoDll()) {
            if (perifericos.getEventoNaoEsperadoListener() != null) {
                cardReaderHandler.getLeitorCartao().removeListener(perifericos.getEventoNaoEsperadoListener());
                perifericos.setEventoNaoEsperadoListener(null);
                perifericos.setEventoNaoEsperado(null);
            }
            perifericos.setEventoNaoEsperadoListener(new AbortPinPadListener(perifericos));
            cardReaderHandler.getLeitorCartao().addListener(perifericos.getEventoNaoEsperadoListener());
        }
        if ((leitorCartao = cardReaderHandler.getLeitorCartao()).getIdRedeAdquirente() > 0 && leitorCartao.getIndiceAID() != null) {
            ArrayList<Aid> listAID = new ArrayList<Aid>();
            listAID.add(this.createAID(leitorCartao.getIdRedeAdquirente(), leitorCartao.getIndiceAID()));
            leitorCartao.setIdsRedeIndTab(listAID);
        } else {
            leitorCartao.setIdsRedeIndTab(Contexto.getContexto().getListAID());
        }
        LeitorCartao dadosLeitorCartao = cardReaderHandler.getLeitorCartao();
        dadosLeitorCartao.setTipoAplicacao(this.infTipoAplicacao(dados));
        if (entradaApiTefC.getValorTransacao() != null) {
            dadosLeitorCartao.setValorInicialTransacao(this.infValorTransacao(entradaApiTefC.getValorTransacao()));
        }
        CMOSPinPad cmosPinPad = CMOSPinPad.getInstance();
        if (Contexto.getContexto().getSaidaApiTefC() != null && Contexto.getContexto().getSaidaApiTefC().getTipoBibliotecaPinpad() == 2) {
            dadosLeitorCartao.setTimeStamp(cmosPinPad.getTimeStamp(leitorCartao.getIdRedeAdquirente()));
        } else {
            dadosLeitorCartao.setTimeStamp(cmosPinPad.getTimeStamp(0));
        }
        dadosLeitorCartao.setDataTransacao(dados.getStartProcess());
        if (OperationEnum.OP_CRED_CARTAO_QUALIDADE.equals((Object)operationEnum)) {
            Contexto.getContexto().setDesabilitaContactlessProximaLeitura(true);
            dadosLeitorCartao.setActionLeituraCartao(LeituraCartaoEnum.QUALIDADE);
            dadosLeitorCartao.setActiveContactless(false);
        }
        try {
            ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
            IdentTerminal identTerminal = null;
            EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
            boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
            boolean multiEC = config.isMultiEC();
            identTerminal = entradaIntegracao != null && (multiTerminal || multiEC) ? Contexto.getContexto().getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
            ControladorInicioDia controladorInicioDia = ControladorInicioDia.getInstance();
            DadosInicioDia dadosInicioDia = controladorInicioDia.getDadosInicioDia(identTerminal);
            if (!OperationEnum.OP_CRED_CARTAO_QUALIDADE.equals((Object)operationEnum)) {
                boolean pinpadSupportsContactless = perifericos.getPin().getInfo().isSuportaContactless();
                boolean enableContactless = true;
                if (Contexto.getContexto().isDesabilitaContactlessProximaLeitura()) {
                    this.logger.info("Cart\u00e3o contactless desabilitado para esta leitura (FALLBACK)");
                    enableContactless = false;
                } else if (!pinpadSupportsContactless) {
                    this.logger.info("Pinpad n\u00e3o suporta contactless");
                    enableContactless = false;
                } else if (!dadosInicioDia.isHabilitaContactless()) {
                    this.logger.info("Contactless desabilitado para este EC");
                    enableContactless = false;
                }
                this.logger.info("Para essa transa\u00e7\u00e3o, o contactless est\u00e1 " + (enableContactless ? "LIGADO" : "DESLIGADO"));
                leitorCartao.setHabilitaContactless(enableContactless);
                entradaApiTefC.setCapacidadeContactlessPinpad(enableContactless);
                cmosPinPad = CMOSPinPad.getInstance();
                PerifericoEventHandler.setActive(true);
                leitorCartao.habilitaTrilha(1);
                leitorCartao.habilitaTrilha(2);
                leitorCartao.habilitaTrilha(3);
            }
            if (confCTFClient.getTentativasConexaoPinpad() == 0) {
                ExcecaoPerifericos ex;
                int cont = 0;
                do {
                    ++cont;
                    ex = null;
                    try {
                        leitorCartao.habilita();
                    }
                    catch (ExcecaoPerifericos e) {
                        ex = e;
                        displayModel = new LayoutDisplay("Erro no PINPAD (" + cont + ")..");
                        perifericos.imprimeDisplay(displayModel);
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                } while (ex != null && cont < 10);
                if (ex != null) {
                    throw ex;
                }
            } else {
                leitorCartao.habilita();
            }
            cmosPinPad.limpaTentativaConexoes();
        }
        catch (ExcecaoInteiroInvalido e) {
            this.logger.error("Erro de inteiro invalido ao habilitar o leitor cart\u00e3o: " + e.getMessage());
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CONECTE_PIN_PAD, MSG_SEM_PINPAD));
            return ERRO;
        }
        catch (ExcecaoBibliotecaCompartilhada e) {
            this.logger.error("Erro da biblioteca compartilhada ao habilitar o leitor cartao: " + e.getMessage());
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.PINPAD_SEM_API_COMPARTILHADA, "PINPAD SEM API COMPARTILHADA"));
            return ERRO;
        }
        catch (ExcecaoComunicacaoSegura e) {
            this.logger.error("Erro de comunicacao segura ao habilitar a comunica\u00e7\u00e3o segura com o pinpad: " + e.getMessage());
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.MSG_ERRO_COMUNICACAO_SEGURA, MSG_ERRO_COMUNICACAO_SEGURA));
            return ERRO;
        }
        catch (ExcecaoPerifericos e) {
            int qtdErro;
            this.logger.error("Erro de perifericos ao habilitar o leitor cartao: " + e.getMessage());
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CONECTE_PIN_PAD, MSG_SEM_PINPAD));
            if (!confCTFClient.isIntegracaoAndroid() && confCTFClient.getTentativasConexaoPinpad() > 0 && (qtdErro = cmosPinPad.novaTentativaConexao()) >= confCTFClient.getTentativasConexaoPinpad()) {
                return CONFIGURA_PINPAD;
            }
            return ERRO;
        }
        return SUCESS;
    }

    private long infValorTransacao(BigDecimal bigDecimal) {
        return bigDecimal.movePointRight(2).longValue();
    }

    private int infTipoAplicacao(Process operacao) {
        int tipoAplicacao = 99;
        String tipoOperacao = Contexto.getContexto().getTipoOperacao();
        if (OperationEnum.OP_CREDITO.getDescription().equals(tipoOperacao) || OperationEnum.OP_CREDITO_GENERICO.getDescription().equals(tipoOperacao)) {
            tipoAplicacao = 1;
        } else if (OperationEnum.OP_DEBITO.getDescription().equals(tipoOperacao) || OperationEnum.OP_DEBITO_GENERICO.getDescription().equals(tipoOperacao) || OperationEnum.OP_CREDIARIO_DE_DEBITO.getDescription().equals(tipoOperacao)) {
            tipoAplicacao = 2;
        } else if (OperationEnum.OP_AUT_IATA.getDescription().equals(tipoOperacao) || OperationEnum.OP_CRED_IATA.getDescription().equals(tipoOperacao)) {
            tipoAplicacao = 1;
        } else if (OperationEnum.OP_SIMULACAO_CREDIARIO_DE_CREDITO.getDescription().equals(tipoOperacao) || OperationEnum.OP_CREDIARIO_DE_CREDITO.getDescription().equals(tipoOperacao)) {
            tipoAplicacao = 1;
        } else if (OperationEnum.OP_PRE_AUT_CRED.getDescription().equals(tipoOperacao) || OperationEnum.OP_CONFIRMACAO_PRE_AUT.getDescription().equals(tipoOperacao)) {
            tipoAplicacao = 1;
        } else if (OperationEnum.OP_CONSULTA_FATURA_CARTAO.getDescription().equals(tipoOperacao) || OperationEnum.OP_CONSULTA_FATURA_CARTAO_DETALHADA.getDescription().equals(tipoOperacao) || OperationEnum.OP_PAGAMENTO_FATURA_CARTAO.getDescription().equals(tipoOperacao)) {
            tipoAplicacao = 1;
        } else if (OperationEnum.OP_CRED_PRIVATE_LABEL.getDescription().equals(tipoOperacao)) {
            tipoAplicacao = 1;
        } else if (OperationEnum.OP_CANCELAMENTO_GENERICO.getDescription().equals(tipoOperacao)) {
            if (Contexto.getContexto().getSaidaConsulta() != null && Contexto.getContexto().getSaidaConsulta().getCodigoTransacao() != null) {
                String codigoTransacaoCancelamento = Contexto.getContexto().getSaidaConsulta().getCodigoTransacao();
                if (codigoTransacaoCancelamento.equals("12")) {
                    tipoAplicacao = 1;
                } else if (codigoTransacaoCancelamento.equals("10")) {
                    tipoAplicacao = 2;
                }
            }
        } else if (OperationEnum.OP_PGTO_FICHA_COMPENSACAO_COM_CONSULTA.getDescription().equals(tipoOperacao) || OperationEnum.OP_PGTO_FICHA_COMPENSACAO.getDescription().equals(tipoOperacao) || OperationEnum.OP_PGTO_CONVENIO_COM_CONSULTA.getDescription().equals(tipoOperacao) || OperationEnum.OP_PGTO_CONVENIO.getDescription().equals(tipoOperacao)) {
            if (Contexto.getContexto().getTipoPagamento() == 5) {
                tipoAplicacao = 1;
            } else if (Contexto.getContexto().getTipoPagamento() == 4) {
                tipoAplicacao = 2;
            }
        } else if (OperationEnum.OP_PAGAMENTO_FATURA_CARTAO_CREDITO.getDescription().equals(tipoOperacao) || OperationEnum.OP_PAGAMENTO_CONTA_BANCARIA.getDescription().equals(tipoOperacao) || OperationEnum.OP_PAGAMENTO_CONTA_CONCESSIONARIA.getDescription().equals(tipoOperacao)) {
            tipoAplicacao = 1;
        }
        return tipoAplicacao;
    }

    private Aid createAID(int redeAdquirente, Integer indiceAID) {
        Aid aid = new Aid();
        aid.setRede(StringUtil.completaString(String.valueOf(redeAdquirente), 2, '0', 3));
        aid.setIndice(StringUtil.completaString(String.valueOf(indiceAID), 2, '0', 3));
        return aid;
    }
}

