/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import java.util.ArrayList;

public class MicHabilitaQrCode
extends MicAbstractBase {
    public static final String REQUIRED_QRCODE = "QRCODE_REQUIRIDO";
    public static final String NOT_REQUIRED_QRCODE = "QRCODE_NAO_REQUIRIDO";
    public static final String UNNECESSARY = "UNNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String DESCRIPTION_QR_CODE = "QR CODE";
    public static final String DESCRIPTION_CARD = "CARTAO";
    public static final String DESCRIPTION_TITLE_TRANSACTION = "SELECIONE A FORMA DE PAGAMENTO:";
    public static final String DESCRIPTION_TITLE_CANCEL = "SELECIONE A FORMA DE CANCELAMENTO:";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        String operacao = Contexto.getContexto().getTipoOperacao();
        if (operacao == null || operacao.equals("") || !this.transacaoPermiteQrCode(operacao)) {
            return NOT_REQUIRED_QRCODE;
        }
        try {
            ControladorInicioDia controladorInicioDia = ControladorInicioDia.getInstance();
            DadosInicioDia dadosInicioDia = controladorInicioDia.getDadosInicioDia(this.getIdentTerminalIgnoreMultiEc());
            if (!dadosInicioDia.isQrCode()) {
                return UNNECESSARY;
            }
        }
        catch (Exception e) {
            this.logger.warn("Falha ao obter dados do dia: " + e.getMessage());
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        ArrayList<String> descriptions = new ArrayList<String>();
        descriptions.add(DESCRIPTION_QR_CODE);
        descriptions.add(DESCRIPTION_CARD);
        int selectedTypeIndex = operacao.equals(OperationEnum.OP_CANCELAMENTO_GENERICO.getDescription()) ? perifericos.showSingleChoiceMenu(dados, DESCRIPTION_TITLE_CANCEL, descriptions) : perifericos.showSingleChoiceMenu(dados, DESCRIPTION_TITLE_TRANSACTION, descriptions);
        this.logger.debug("\u00cdndice de produto selecionado = " + selectedTypeIndex);
        if (selectedTypeIndex == -1) {
            this.logger.info("Sele\u00e7\u00e3o de produto cancelada pelo usu\u00e1rio");
            return USER_CANCEL;
        }
        if (selectedTypeIndex == 0) {
            Contexto.getContexto().setTransacaoSemCartao(true);
            return REQUIRED_QRCODE;
        }
        return NOT_REQUIRED_QRCODE;
    }

    boolean transacaoPermiteQrCode(String transacao) {
        return transacao.equals(OperationEnum.OP_DEBITO.getDescription()) || transacao.equals(OperationEnum.OP_DEBITO_GENERICO.getDescription()) || transacao.equals(OperationEnum.OP_CREDITO.getDescription()) || transacao.equals(OperationEnum.OP_CRED_PARC_SEM_JUROS.getDescription()) || transacao.equals(OperationEnum.OP_CRED_PARC_COM_JUROS.getDescription()) || transacao.equals(OperationEnum.OP_CREDITO_GENERICO.getDescription()) || transacao.equals(OperationEnum.OP_CANCELAMENTO_GENERICO.getDescription());
    }
}

