/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.entrada.ICriptografiaDUKPT;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.EventoPinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicLeituraCertificadoDUKPT {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(ICriptografiaDUKPT dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("INJCHADUK_TITLE"));
        EventoDispositivoEntrada evento = null;
        String msgDisplay = "";
        ControladorPerifericos perifericos = dados.getPerifericos();
        try {
            do {
                if (!msgDisplay.equals("")) {
                    displayModel = new LayoutDisplay(msgDisplay);
                    perifericos.imprimeDisplay(displayModel);
                }
                if (!((evento = perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_GENERIC_COMMAND, false, new long[]{4L})) instanceof EventoTeclado)) continue;
                boolean abort = false;
                if ("ABORT".equals(((EventoTeclado)evento).getTeclaFinalizadora())) {
                    abort = true;
                } else if ("VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) && perifericos.exibeMenuCancelamento() == 1) {
                    abort = true;
                }
                if (!abort) continue;
                try {
                    if (perifericos.getPin() == null) continue;
                    perifericos.getPin().desabilita();
                    while (perifericos.getPin().isLeitura()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            logger.info("Espera do pin foi interrompida: " + e.getMessage());
                        }
                    }
                }
                catch (ExcecaoPerifericos e) {
                    logger.warn("Nao foi possivel desativar o pin: " + e.getMessage());
                }
            } while (evento instanceof EventoTeclado && "VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) && perifericos.getPin().getHabilitado());
        }
        catch (ExcecaoPerifericos e) {
            logger.error("Erro ao capturar dado: " + e.getMessage());
            return ERROR;
        }
        if (evento instanceof EventoPinEMV) {
            EventoPinEMV eventoPinEMV = (EventoPinEMV)evento;
            if (eventoPinEMV.getErro()) {
                Contexto.getContexto().setErrorCode(eventoPinEMV.getErroCodigo());
                if (Contexto.getContexto().getEntradaIntegracao() != null) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_AO_TENTAR_GERAR_CERTIFICADO_DUKPT, "ERRO NA EXECUCAO DA PP_GENERIC_COMMAND AO TENTAR GERAR O CERTIFICADO DUKPT"));
                } else {
                    Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
                }
                displayModel = new LayoutDisplay(inter.getMessage("LEIPIN_ERRO") + eventoPinEMV.getErroCodigo(), 1500L);
                perifericos.imprimeDisplay(displayModel);
                return ERROR;
            }
            if (eventoPinEMV.getDigitacaoCancelada()) {
                return USER_CANCEL;
            }
            switch (eventoPinEMV.getErroCodigo()) {
                case 1: 
                case 2: {
                    logger.debug("");
                    Contexto.getContexto().setErrorCode(eventoPinEMV.getErroCodigo());
                    if (Contexto.getContexto().getEntradaIntegracao() != null) {
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_AO_TENTAR_GERAR_CERTIFICADO_DUKPT, "ERRO NA EXECUCAO DA PP_GENERIC_COMMAND AO TENTAR GERAR O CERTIFICADO DUKPT"));
                    } else if (Contexto.getContexto().getSaidaApiTefC() != null) {
                        Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
                    }
                    displayModel = new LayoutDisplay(inter.getMessage("LEIPIN_ERRO") + eventoPinEMV.getErroCodigo(), 1500L);
                    perifericos.imprimeDisplay(displayModel);
                    return USER_CANCEL;
                }
            }
            String bufferGenericCommand = eventoPinEMV.getBufferRespostaGenericCommand();
            if (bufferGenericCommand == null || bufferGenericCommand.length() < 263) {
                logger.error("Buffer de resposta do PP_GenericCmd menor que o esperado: " + bufferGenericCommand);
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_AO_TENTAR_GERAR_CERTIFICADO_DUKPT, "ERRO NA EXECUCAO DA PP_GENERIC_COMMAND AO TENTAR GERAR O CERTIFICADO DUKPT"));
                return ERROR;
            }
            dados.setIdentificadorChaveRSA(bufferGenericCommand.substring(3, 7));
            dados.setCertificadoCriptografico(bufferGenericCommand.substring(7, 263));
            EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
            entradaApiTefC.setIdentificadorChaveRSA(bufferGenericCommand.substring(3, 7));
            entradaApiTefC.setCertificadoCriptografico(bufferGenericCommand.substring(7, 263));
            return SUCCESS;
        }
        if (evento instanceof EventoTeclado) {
            try {
                if (perifericos.getPin() != null) {
                    BibliotecaPinpad pin = (BibliotecaPinpad)perifericos.getPin();
                    pin.desabilita();
                }
            }
            catch (ExcecaoPerifericos excecaoPerifericos) {
                logger.warn("Nao foi possivel desabilitar o pin depois da captura: " + excecaoPerifericos.getMessage());
            }
            return USER_CANCEL;
        }
        return ERROR;
    }
}

