/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.EventoPinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicLeituraConsultaDadosEMV {
    public static final String SUCCESS = "SUCCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR = "ERROR";
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        EventoDispositivoEntrada evento;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("LEICONDADEMV_TITLE"));
        ControladorPerifericos perifericos = dados.getPerifericos();
        try {
            do {
                if (!((evento = perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_GENERIC_COMMAND, false, new long[]{4L})) instanceof EventoTeclado)) continue;
                boolean abort = false;
                if ("ABORT".equals(((EventoTeclado)evento).getTeclaFinalizadora())) {
                    abort = true;
                } else if ("VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) && perifericos.exibeMenuCancelamento() == 1) {
                    abort = true;
                }
                if (!abort) continue;
                try {
                    perifericos.getPin().desabilita();
                    while (perifericos.getPin().isLeitura()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            logger.info("Espera do pinpad foi interrompida: " + e.getMessage());
                        }
                    }
                }
                catch (ExcecaoPerifericos e) {
                    logger.warn("Nao foi possivel desabilitar o pin: " + e.getMessage());
                }
            } while (evento instanceof EventoTeclado && "VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) && perifericos.getPin().getHabilitado());
        }
        catch (ExcecaoPerifericos e) {
            logger.error("Nao foi possivel capturar dado: " + e.getMessage());
            return ERROR;
        }
        if (evento instanceof EventoPinEMV) {
            EventoPinEMV eventoPinEMV = (EventoPinEMV)evento;
            if (eventoPinEMV.getErro()) {
                Contexto.getContexto().setErrorCode(eventoPinEMV.getErroCodigo());
                if (Contexto.getContexto().getEntradaIntegracao() != null) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TENTE_NOVAMENTE, "TENTE NOVAMENTE"));
                } else {
                    Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
                }
                displayModel = new LayoutDisplay(inter.getMessage("LEIPIN_ERRO") + eventoPinEMV.getErroCodigo(), 1500L);
                perifericos.imprimeDisplay(displayModel);
                return ERROR;
            }
            if (eventoPinEMV.getDigitacaoCancelada()) {
                return USER_CANCEL;
            }
            switch (eventoPinEMV.getErroCodigo()) {
                case 1: 
                case 2: {
                    logger.debug("Retorno: " + eventoPinEMV.getErroCodigo() + " inesperado na PP_Generic_Command");
                    Contexto.getContexto().setErrorCode(eventoPinEMV.getErroCodigo());
                    if (Contexto.getContexto().getEntradaIntegracao() != null) {
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TENTE_NOVAMENTE, "TENTE NOVAMENTE"));
                    } else if (Contexto.getContexto().getSaidaApiTefC() != null) {
                        Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
                    }
                    displayModel = new LayoutDisplay(inter.getMessage("LEIPIN_ERRO") + eventoPinEMV.getErroCodigo(), 1500L);
                    perifericos.imprimeDisplay(displayModel);
                    return USER_CANCEL;
                }
            }
            String bufferGenericCommand = eventoPinEMV.getBufferRespostaGenericCommand();
            if (bufferGenericCommand == null || bufferGenericCommand.length() < 3) {
                logger.error("Buffer de resposta do PP_GenericCmd menor que o esperado: " + bufferGenericCommand);
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_AO_TENTAR_GERAR_CERTIFICADO_DUKPT, "ERRO NA EXECUCAO DA PP_GENERIC_COMMAND AO TENTAR LER DADOS EMV"));
                return ERROR;
            }
            Contexto.getContexto().getEntradaApiTefC().setTagsGenericCommand(bufferGenericCommand.substring(3));
            Contexto.getContexto().setSaidaApiTefC(null);
            return SUCCESS;
        }
        if (evento instanceof EventoTeclado) {
            try {
                BibliotecaPinpad pin = (BibliotecaPinpad)perifericos.getPin();
                pin.desabilita();
            }
            catch (ExcecaoPerifericos excecaoPerifericos) {
                logger.warn("Nao foi possivel desabilitar o pin: " + excecaoPerifericos.getMessage());
            }
            return USER_CANCEL;
        }
        return ERROR;
    }
}

