/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.entrada.ICriptografiaDUKPT;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.EventoPinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicLeituraInjetarChaveDUKPT {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(ICriptografiaDUKPT dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("INJCHADUK_TITLE"));
        EventoDispositivoEntrada evento = null;
        String msgDisplay = "";
        ControladorPerifericos perifericos = dados.getPerifericos();
        do {
            if (msgDisplay.equals("")) continue;
            displayModel = new LayoutDisplay(msgDisplay);
            perifericos.imprimeDisplay(displayModel);
        } while ((evento = perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_GENERIC_COMMAND, false, new long[]{1L, 4L})) instanceof EventoTeclado && ("VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) && perifericos.exibeMenuCancelamento() == 2 || "ENTRA".equals(((EventoTeclado)evento).getTeclaFinalizadora())));
        if (evento instanceof EventoPinEMV) {
            EventoPinEMV eventoPinEMV = (EventoPinEMV)evento;
            if (eventoPinEMV.getErro()) {
                Contexto.getContexto().setErrorCode(eventoPinEMV.getErroCodigo());
                if (Contexto.getContexto().getEntradaIntegracao() != null) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_AO_TENTAR_GERAR_CERTIFICADO_DUKPT, "ERRO NA EXECUCAO DA PP_GENERIC_COMMAND AO TENTAR INJETAR A CHAVE DUKPT"));
                } else {
                    Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
                }
                displayModel = new LayoutDisplay(inter.getMessage("LEIPIN_ERRO") + eventoPinEMV.getErroCodigo() + " " + inter.getMessage("LEIINJCHADUK_ERRO_INJECAO"), 1500L);
                perifericos.imprimeDisplay(displayModel);
                return ERROR;
            }
            if (eventoPinEMV.getDigitacaoCancelada()) {
                return USER_CANCEL;
            }
            switch (eventoPinEMV.getErroCodigo()) {
                case 1: 
                case 2: {
                    logger.debug("");
                    Contexto.getContexto().setErrorCode(eventoPinEMV.getErroCodigo());
                    if (Contexto.getContexto().getEntradaIntegracao() != null) {
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_AO_TENTAR_GERAR_CERTIFICADO_DUKPT, "ERRO NA EXECUCAO DA PP_GENERIC_COMMAND AO TENTAR INJETAR A CHAVE DUKPT"));
                    } else if (Contexto.getContexto().getSaidaApiTefC() != null) {
                        Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
                    }
                    displayModel = new LayoutDisplay(inter.getMessage("LEIPIN_ERRO") + eventoPinEMV.getErroCodigo(), 1500L);
                    perifericos.imprimeDisplay(displayModel);
                    return USER_CANCEL;
                }
            }
            return SUCCESS;
        }
        if (evento instanceof EventoTeclado) {
            try {
                BibliotecaPinpad pin = (BibliotecaPinpad)perifericos.getPin();
                pin.desabilita();
            }
            catch (ExcecaoPerifericos excecaoPerifericos) {
                logger.warn("Nao foi possivel desabilitar o pin: " + excecaoPerifericos.getMessage());
            }
            return USER_CANCEL;
        }
        return ERROR;
    }
}

