/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.constantes.RemoveCardMessage;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.entrada.ILeituraPin;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorEstatistica;
import com.csi.ctfclient.operacoes.model.DadosEstatistica;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.EventoPinEMV;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicLeituraPin {
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_RETRY = "USERCANCEL_RETRY";
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    private AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(ILeituraPin dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        String titulo = dados.getTituloAguardaPin() != null && !dados.getTituloAguardaPin().equals("") ? dados.getTituloAguardaPin() : inter.getMessage("LEIPIN_TITLE");
        LayoutDisplay displayModel = null;
        if (titulo.indexOf("#") != 0) {
            String[] mensagens = titulo.split("#");
            displayModel = new LayoutDisplay();
            displayModel.setImagem(LayoutDisplay.imagens.aguarde_senha);
            for (int i = 0; i < mensagens.length; ++i) {
                displayModel.addLinha(new Linha(mensagens[i]));
            }
        } else {
            displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(titulo));
        }
        EventoDispositivoEntrada evento = null;
        String msgDisplay = "";
        PinEMV pinEMV = null;
        try {
            pinEMV = perifericos.getPin();
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.warn("Nao foi possivel carregar o pinpad: " + excecaoPerifericos.getMessage());
        }
        do {
            if (!msgDisplay.equals("")) {
                displayModel = new LayoutDisplay(msgDisplay);
                perifericos.imprimeDisplay(displayModel);
            }
            if (!((evento = this.getEvent(displayModel, perifericos)) instanceof EventoTeclado)) continue;
            boolean abort = false;
            if ("ABORT".equals(((EventoTeclado)evento).getTeclaFinalizadora())) {
                abort = true;
            } else if ("VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) && perifericos.exibeMenuCancelamento() == 1) {
                abort = true;
            }
            if (!abort || pinEMV == null) continue;
            try {
                pinEMV.desabilita();
                while (pinEMV.isLeitura()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        this.logger.info("Espera do pinpad foi interrompida: " + e.getMessage());
                    }
                }
            }
            catch (ExcecaoPerifericos excecaoPerifericos) {
                this.logger.warn("Nao foi possivel desabilitar o pin: " + excecaoPerifericos.getMessage());
            }
        } while (evento instanceof EventoTeclado && "VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) && pinEMV.getHabilitado());
        if (evento instanceof EventoPinEMV) {
            EventoPinEMV eventoPinEMV = (EventoPinEMV)evento;
            if (eventoPinEMV.getErro()) {
                Contexto.getContexto().setErrorCode(eventoPinEMV.getErroCodigo());
                if (Contexto.getContexto().getEntradaIntegracao() != null) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_CAPTURA_PIN, "ERRO NA CAPTURA DO PIN"));
                } else {
                    saidaApiTefC.setRetorno(20);
                }
                if (dados.isPossuiChaveContingencia() && eventoPinEMV.getErroCodigo() == 42) {
                    this.logger.info("Erro ao utilizar a criptografia principal de senha, a conting\u00eancia ser\u00e1 utilizada");
                    return ERRO;
                }
                displayModel = new LayoutDisplay(inter.getMessage("LEIPIN_ERRO") + eventoPinEMV.getErroCodigo(), 1500L);
                perifericos.imprimeDisplay(displayModel);
                return ERRO;
            }
            if (Contexto.getContexto().getCartao() == Cartao.CHIP) {
                Contexto.getContexto().setRemoveCardMessage(RemoveCardMessage.MSG_TRANS_APROVADA);
                Contexto.getContexto().setErrorCode(0);
            }
            if (eventoPinEMV.getDigitacaoCancelada()) {
                return USERCANCEL;
            }
            switch (eventoPinEMV.getErroCodigo()) {
                case 1: 
                case 2: {
                    this.logger.debug("");
                    Contexto.getContexto().setErrorCode(eventoPinEMV.getErroCodigo());
                    if (Contexto.getContexto().getEntradaIntegracao() != null) {
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_CAPTURA_PIN, "ERRO NA CAPTURA DO PIN"));
                    } else if (Contexto.getContexto().getSaidaApiTefC() != null) {
                        saidaApiTefC.setRetorno(20);
                    }
                    displayModel = new LayoutDisplay(inter.getMessage("LEIPIN_ERRO") + eventoPinEMV.getErroCodigo(), 1500L);
                    perifericos.imprimeDisplay(displayModel);
                    return ERRO;
                }
            }
            dados.setTeclaFuncaoPressionada(eventoPinEMV.getErroCodigo());
            PinInfo pinInfo = new PinInfo();
            pinInfo.setPinCriptografado(eventoPinEMV.getCodigo());
            pinInfo.setNumeroSerieChaveDUKPT(eventoPinEMV.getNumeroSerieChaveDUKPT());
            pinInfo.setStatusAprovacaoTransacao(eventoPinEMV.getStatusAprovacaoTransacao());
            pinInfo.setCapturadoVerificacaoOnline(true);
            pinInfo.setVerificadoOffline(eventoPinEMV.getPinVerificadoOffline());
            pinInfo.setRequerAssinatura(eventoPinEMV.getRequerAssinaturaPapel());
            Contexto.getContexto().setPinInfo(pinInfo);
            if (dados.isCapturaSenha()) {
                try {
                    boolean persistirDados = false;
                    ControladorEstatistica controladorEstatistica = ControladorEstatistica.getInstance();
                    DadosEstatistica dadosEstatistica = controladorEstatistica.getDadosEstatistica();
                    if (Contexto.getContexto().getCartao() == Cartao.MAGNETICO) {
                        dadosEstatistica.addSenhaPinMagnetico();
                        persistirDados = true;
                    }
                    if (persistirDados) {
                        controladorEstatistica.persistirDados(dadosEstatistica);
                    }
                }
                catch (ExcecaoApiAc e) {
                    this.logger.error("Erro ao contabilizar estat\u00edstica em MicLeituraPin: " + e.getMessage());
                }
            }
            return SUCESS;
        }
        if (evento instanceof EventoTeclado) {
            if (pinEMV != null) {
                BibliotecaPinpad pin = (BibliotecaPinpad)pinEMV;
                try {
                    pin.desabilita();
                }
                catch (ExcecaoPerifericos excecaoPerifericos) {
                    this.logger.warn("Nao foi possivel desabilitar o pin: " + excecaoPerifericos.getMessage());
                }
            }
            return USERCANCEL;
        }
        return ERRO;
    }

    public EventoDispositivoEntrada getEvent(LayoutDisplay displayModel, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        EventoDispositivoEntrada event = perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_LEITURA_PIN, false, new long[]{1L, 4L});
        if (event == null) {
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_DE_SISTEMA, "ERRO DE SISTEMA!"));
            this.logger.error("Erro no MicLeituraPin ao capturar o PIN. Atributo evento est\u00e1 nulo!");
        }
        return event;
    }
}

