/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class MicLeituraTipoFinanciamentoCredito {
    public static final String SUCESS_AVISTA = "SUCESS_AVISTA";
    public static final String SUCESS_APRAZOLOJISTA = "SUCESS_APRAZOLOJISTA";
    public static final String SUCESS_APRAZOADMINISTRADO = "SUCESS_APRAZOADMINISTRADO";
    public static final String SUCCESS_CREDIARIO = "SUCCESS_CREDIARIO";
    public static final String FILLED = "FILLED";
    public static final String FILLED_CREDIARIO = "FILLED_CREDIARIO";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERROR = "ERROR";
    private static final List<Integer> operacoesExcludentes = Arrays.asList(OperationEnum.OP_QR_CODE_GENERICO.getKey(), OperationEnum.OP_CREDITO_GENERICO.getKey(), OperationEnum.OP_CANCELAMENTO_GENERICO.getKey(), OperationEnum.OP_CANCELAMENTO_DIGITADO.getKey(), OperationEnum.OP_CONFIRMACAO_PRE_AUT_GENERICO.getKey(), OperationEnum.OP_BYPASS.getKey(), OperationEnum.OP_CREDITO_4ALL.getKey(), OperationEnum.OP_PAGAMENTO_FATURA_CARTAO_CREDITO.getKey(), OperationEnum.OP_PAGAMENTO_CONTA_BANCARIA.getKey(), OperationEnum.OP_PAGAMENTO_CONTA_CONCESSIONARIA.getKey());
    private static final List<Integer> operacoesAhVista = Arrays.asList(OperationEnum.OP_CREDITO.getKey(), OperationEnum.OP_CRED_DIGITADO.getKey(), OperationEnum.OP_CRED_DIGITADO_PRIMEIRA_COMPRA.getKey(), OperationEnum.OP_CONFIRMACAO_PRE_AUT.getKey(), OperationEnum.OP_CONFIRMACAO_PRE_AUT_DIGITADO.getKey(), OperationEnum.OP_VENDA_PBM_GETNET_AVISTA.getKey(), OperationEnum.OP_ALTERACAO_PRE_AUT.getKey());
    private static final List<Integer> operacoesAdministradora = Arrays.asList(OperationEnum.OP_CRED_PARC_COM_JUROS.getKey(), OperationEnum.OP_CRED_DIGITADO_PARC_COM_JUROS.getKey(), OperationEnum.OP_CRED_DIGITADO_PRIMEIRA_COMPRA_PARC_C_JRS.getKey(), OperationEnum.OP_CONFIRMACAO_PRE_AUT_COM_JUROS.getKey(), OperationEnum.OP_CONFIRMACAO_PRE_AUT_DIGITADO_COM_JUROS.getKey(), OperationEnum.OP_VENDA_PBM_GETNET_COM_JUROS.getKey());
    private final List<Integer> operacoesLojista = Arrays.asList(OperationEnum.OP_CRED_PARC_SEM_JUROS.getKey(), OperationEnum.OP_CRED_DIGITADO_PARC_SEM_JUROS.getKey(), OperationEnum.OP_CRED_DIGITADO_PRIMEIRA_COMPRA_PARC_S_JRS.getKey(), OperationEnum.OP_CONFIRMACAO_PRE_AUT_SEM_JUROS.getKey(), OperationEnum.OP_CONFIRMACAO_PRE_AUT_DIGITADO_SEM_JUROS.getKey(), OperationEnum.OP_VENDA_PBM_GETNET_SEM_JUROS.getKey());

    public String execute(Process dados) throws ExcecaoNaoLocal {
        boolean habilitadoCrediario;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        boolean habilitadoAVista = saidaApiTefC.isPedePlanoAVista();
        boolean habilitadoFinanciadoLojista = saidaApiTefC.isPedePlanoLojista();
        boolean habilitadoAdministradora = saidaApiTefC.isPedePlanoAdministradora();
        boolean bl = habilitadoCrediario = saidaApiTefC.getMinParcelas() != null;
        if (Contexto.getContexto().getPlano() != null) {
            if (Contexto.getContexto().getPlano() == Plano.CREDIARIO) {
                return FILLED_CREDIARIO;
            }
            return FILLED;
        }
        if (entradaIntegracao != null && !operacoesExcludentes.contains(entradaIntegracao.getOperacao())) {
            if (operacoesAhVista.contains(entradaIntegracao.getOperacao())) {
                if (habilitadoAVista) {
                    Contexto.getContexto().setPlano(Plano.AVISTA);
                    return SUCESS_AVISTA;
                }
            } else if (this.operacoesLojista.contains(entradaIntegracao.getOperacao())) {
                if (habilitadoFinanciadoLojista) {
                    Contexto.getContexto().setPlano(Plano.LOJISTA);
                    return SUCESS_APRAZOLOJISTA;
                }
            } else if (operacoesAdministradora.contains(entradaIntegracao.getOperacao()) && habilitadoAdministradora) {
                Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                return SUCESS_APRAZOADMINISTRADO;
            }
            if (Contexto.getContexto().getPlano() == null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.OPERACAO_NAO_PERMITIDA, inter.getMessage("LEITIPFIN_OPERATION_NOT_ALLOWED")));
                return ERROR;
            }
        } else {
            Vector<String> vtTitleMenu = new Vector<String>();
            if (habilitadoAVista) {
                vtTitleMenu.add(inter.getMessage("LEITIPFIN_MENU_AVISTA"));
            }
            if (habilitadoAdministradora) {
                vtTitleMenu.add(inter.getMessage("LEITIPFIN_MENU_ADMINISTRADORA"));
            }
            if (habilitadoFinanciadoLojista) {
                vtTitleMenu.add(inter.getMessage("LEITIPFIN_MENU_FINANCIADO_LOJISTA"));
            }
            if (habilitadoCrediario) {
                vtTitleMenu.add(inter.getMessage("LEITIPFINCRE_MENU_CREDIARIO"));
            }
            ControladorPerifericos perifericos = dados.getPerifericos();
            if (vtTitleMenu.size() == 0) {
                Contexto.getContexto().setPlano(null);
                return ERROR;
            }
            if (vtTitleMenu.size() == 1) {
                if (habilitadoAVista) {
                    Contexto.getContexto().setPlano(Plano.AVISTA);
                    return SUCESS_AVISTA;
                }
                if (habilitadoAdministradora) {
                    Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                    return SUCESS_APRAZOADMINISTRADO;
                }
                if (habilitadoFinanciadoLojista) {
                    Contexto.getContexto().setPlano(Plano.LOJISTA);
                    return SUCESS_APRAZOLOJISTA;
                }
                if (habilitadoCrediario) {
                    Contexto.getContexto().setPlano(Plano.CREDIARIO);
                    return SUCCESS_CREDIARIO;
                }
            } else {
                LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("LEITIPFIN_TITLE"), true);
                int iTecla = 1;
                for (int i = 0; i < vtTitleMenu.size(); ++i) {
                    layoutMenu.addItem(new ItemMenu((String)vtTitleMenu.get(i), String.valueOf(iTecla)));
                    ++iTecla;
                }
                int opcao = perifericos.imprimeMenu(layoutMenu);
                if (opcao == -1) {
                    return USERCANCEL;
                }
                ItemMenu itemSelecionado = layoutMenu.getItens().get(opcao - 1);
                if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFIN_MENU_AVISTA"))) {
                    Contexto.getContexto().setPlano(Plano.AVISTA);
                    return SUCESS_AVISTA;
                }
                if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFIN_MENU_FINANCIADO_LOJISTA"))) {
                    Contexto.getContexto().setPlano(Plano.LOJISTA);
                    return SUCESS_APRAZOLOJISTA;
                }
                if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFIN_MENU_ADMINISTRADORA"))) {
                    Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                    return SUCESS_APRAZOADMINISTRADO;
                }
                if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFINCRE_MENU_CREDIARIO"))) {
                    Contexto.getContexto().setPlano(Plano.CREDIARIO);
                    return SUCCESS_CREDIARIO;
                }
            }
        }
        return ERROR;
    }
}

