/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.Vector;

public class MicLeituraTipoFinanciamentoPreAutorizacao {
    public static final String SUCCESS_AVISTA = "SUCESS_AVISTA";
    public static final String SUCCESS_APRAZO = "SUCESS_APRAZO";
    public static final String SUCCESS_LOJISTA = "SUCCESS_LOJISTA";
    public static final String SUCCESS_ADMINISTRADORA = "SUCCESS_ADMINISTRADORA";
    public static final String FILLED_AVISTA = "FILLED_AVISTA";
    public static final String FILLED_APRAZO = "FILLED_APRAZO";
    public static final String ERROR_FINANCIAMENTO_AC = "ERROR_FINANCIAMENTO_AC";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR = "ERROR";
    private static final String MSG_OPERATION_NOT_ALLOWED = "OPERACAO NAO PERMITIDA";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        boolean habilitadoFinanciadoLojista;
        boolean habilitadoAdministradora;
        boolean habilitadoAPrazo;
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        boolean bl = habilitadoAPrazo = !saidaApiTefC.isFinanciamentoPreAutHabilitado() && saidaApiTefC.getHabilitaCDC_PRE() == 1;
        if (entradaIntegracao != null && entradaIntegracao.isNumeroParcelasCtrl()) {
            if (entradaIntegracao.getNumeroParcelas() == 1) {
                Contexto.getContexto().setPlano(Plano.AVISTA);
                return SUCCESS_AVISTA;
            }
            if (entradaIntegracao.getNumeroParcelas() > 1) {
                if (habilitadoAPrazo) {
                    Contexto.getContexto().setPlano(Plano.CDC);
                    return SUCCESS_APRAZO;
                }
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.OPERACAO_NAO_PERMITIDA, MSG_OPERATION_NOT_ALLOWED));
                return ERROR_FINANCIAMENTO_AC;
            }
        }
        if (Contexto.getContexto().getPlano() != null) {
            if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                return FILLED_AVISTA;
            }
            if (Contexto.getContexto().getPlano() == Plano.CDC) {
                return FILLED_APRAZO;
            }
            return ERROR_FINANCIAMENTO_AC;
        }
        Vector<String> vtTitleMenu = new Vector<String>();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        boolean habilitadoAVista = saidaApiTefC.isPedePlanoAVista();
        if (habilitadoAVista) {
            vtTitleMenu.add(inter.getMessage("LEITIPFINPREAUT_MENU_AVISTA"));
        }
        if (habilitadoAPrazo) {
            vtTitleMenu.add(inter.getMessage("LEITIPFINPREAUT_MENU_APRAZO"));
        }
        boolean bl2 = habilitadoAdministradora = saidaApiTefC.isFinanciamentoPreAutHabilitado() && saidaApiTefC.isPedePlanoAdministradora();
        if (habilitadoAdministradora) {
            vtTitleMenu.add(inter.getMessage("LEITIPFINPREAUT_MENU_ADMINISTRADORA"));
        }
        boolean bl3 = habilitadoFinanciadoLojista = saidaApiTefC.isFinanciamentoPreAutHabilitado() && saidaApiTefC.isPedePlanoLojista();
        if (habilitadoFinanciadoLojista) {
            vtTitleMenu.add(inter.getMessage("LEITIPFINPREAUT_MENU_LOJISTA"));
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (vtTitleMenu.size() == 0) {
            Contexto.getContexto().setPlano(null);
            return ERROR;
        }
        if (vtTitleMenu.size() == 1) {
            if (habilitadoAVista) {
                Contexto.getContexto().setPlano(Plano.AVISTA);
                return SUCCESS_AVISTA;
            }
            if (habilitadoAPrazo) {
                Contexto.getContexto().setPlano(Plano.CDC);
                return SUCCESS_APRAZO;
            }
        } else {
            LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("LEITIPFINPREAUT_TITLE"), true);
            int iTecla = 1;
            for (int i = 0; i < vtTitleMenu.size(); ++i) {
                layoutMenu.addItem(new ItemMenu((String)vtTitleMenu.get(i), String.valueOf(iTecla)));
                ++iTecla;
            }
            int opcao = perifericos.imprimeMenu(layoutMenu);
            if (opcao == -1) {
                return USER_CANCEL;
            }
            ItemMenu itemSelecionado = layoutMenu.getItens().get(opcao - 1);
            if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFINPREAUT_MENU_AVISTA"))) {
                Contexto.getContexto().setPlano(Plano.AVISTA);
                return SUCCESS_AVISTA;
            }
            if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFINPREAUT_MENU_APRAZO"))) {
                Contexto.getContexto().setPlano(Plano.CDC);
                return SUCCESS_APRAZO;
            }
            if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFINPREAUT_MENU_ADMINISTRADORA"))) {
                Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                return SUCCESS_ADMINISTRADORA;
            }
            if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFINPREAUT_MENU_LOJISTA"))) {
                Contexto.getContexto().setPlano(Plano.LOJISTA);
                return SUCCESS_LOJISTA;
            }
        }
        return ERROR;
    }
}

