/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;

public class MicLeituraValor {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERROR_AC = "ERROR_AC";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getValorTransacao() != null) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            if (!Contexto.getContexto().getEntradaIntegracao().isValorTransacaoCtrl() && this.valorObrigatorio(confCTFClient, OperationEnum.getEnumByKey(Contexto.getContexto().getEntradaIntegracao().getOperacao()))) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.VALOR_NAO_INFORMADO, "VALOR NAO INFORMADO"));
                return ERROR_AC;
            }
            if (Contexto.getContexto().getEntradaIntegracao().isValorTransacaoCtrl()) {
                Contexto.getContexto().getEntradaApiTefC().setValorTransacao(Contexto.getContexto().getEntradaIntegracao().getValorTransacao());
                return SUCESS;
            }
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        String msg = "";
        msg = confCTFClient.isIntegracaoAndroid() && Contexto.getContexto().getEntradaIntegracao().getOperacao() != OperationEnum.OP_CANCELAMENTO_GENERICO.getKey().intValue() ? "VALOR TRANSACAO" : inter.getMessage("LEIVAL_TITLE");
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(msg));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_TRANSACAO, true, 3, false);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            return INVALID_NUMBER;
        }
        BigDecimal valor = new BigDecimal(digitos);
        if (valor.equals(new BigDecimal(0))) {
            return INVALID_NUMBER;
        }
        valor = valor.movePointLeft(2);
        Contexto.getContexto().getEntradaApiTefC().setValorTransacao(valor);
        return SUCESS;
    }

    private boolean valorObrigatorio(ConfCTFClient confCTFClient, OperationEnum operacao) {
        if (confCTFClient.isIntegracaoAndroid()) {
            return false;
        }
        switch (operacao) {
            case OP_CANCELAMENTO_GENERICO: 
            case OP_CANCELAMENTO_DIGITADO: 
            case OP_ESTORNO_PAG: 
            case OP_COMPRA_CREDITO_DIGITAL: 
            case OP_TROCO_SURPRESA: 
            case OP_TEF_IP_MENU_ADM: 
            case OP_DEPOSITO_COM_DOCUMENTO: 
            case OP_DEPOSITO_COM_CARTAO: 
            case OP_PAGAMENTO_FATURA_CARTAO: 
            case OP_CAPTURA_CREDITO: 
            case OP_ATIVACAO_CARTAO_PREPAGO: 
            case OP_DOTZ_ACUMULO: 
            case OP_DOTZ_RESGATE: 
            case OP_RESGATE_FACIL_EXTRATO: 
            case OP_RESGATE_BR_PREMMIA: 
            case OP_CONFIRMACAO_PRE_AUT_GENERICO: 
            case OP_PAGAMENTO_DINHEIRO_BR_PREMMIA: {
                return false;
            }
        }
        return true;
    }
}

