/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.QrCodeGenerator;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiCtf;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractSolicitacaoTEF;
import com.csi.ctfclient.operacoes.model.controller.ControladorPersistencia;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.util.StringUtil;

public class MicQueryQrCode
extends MicAbstractSolicitacaoTEF {
    public static final String ERROR = "ERROR";
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";

    @Override
    public String derivedExecute(Process parent) throws ExcecaoNaoLocal {
        this.logger = parent.getLoggerFactory().getLogger(CTFClientCore.class);
        SaidaApiTefC queryOutput = Contexto.getContexto().getSaidaApiTefC();
        if (queryOutput != null && !StringUtil.isEmpty(queryOutput.getQrcodeHash())) {
            this.logger.debug("Reutilizando o hash para o QR Code " + queryOutput.getQrcodeHash());
            return FILLED;
        }
        try {
            this.setPinpadData(3);
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.warn("Nao foi possivel coletar todos os dados do pinpad: " + excecaoPerifericos.getMessage());
        }
        Contexto.getContexto().getEntradaApiTefC().setCodigoTransacao(this.getCodigoTransacaoQrCode());
        String result = this.genericExecute(parent);
        String qrcodeImageString = Contexto.getContexto().getSaidaApiTefC().getQrcodeImageString();
        if (StringUtil.isEmpty(qrcodeImageString)) {
            this.logger.error("Erro ao gerar o QR Code: subcampo 0513 vazio ou ausente");
            return ERROR;
        }
        QrCodeGenerator qrCodeGenerator = parent.getqrCodeGenerator();
        byte[] imageByte = qrCodeGenerator.createQrCode(qrcodeImageString);
        this.saveQrCodeImage(imageByte);
        return result;
    }

    private String getCodigoTransacaoQrCode() {
        String op = Contexto.getContexto().getTipoOperacao();
        if (op.equals(OperationEnum.OP_CREDITO_GENERICO.getDescription())) {
            switch (Contexto.getContexto().getPlano()) {
                case ADMINISTRADORA: {
                    return ConstantesApiCtf.CONSULTA_QR_CODE_CREDITO_ADMINISTRADORA.getValue();
                }
                case LOJISTA: {
                    return ConstantesApiCtf.CONSULTA_QR_CODE_CREDITO_LOJISTA.getValue();
                }
            }
            return ConstantesApiCtf.CONSULTA_QR_CODE_CREDITO_AVISTA.getValue();
        }
        if (op.equals(OperationEnum.OP_CREDITO.getDescription())) {
            return ConstantesApiCtf.CONSULTA_QR_CODE_CREDITO_AVISTA.getValue();
        }
        if (op.equals(OperationEnum.OP_CRED_PARC_SEM_JUROS.getDescription())) {
            return ConstantesApiCtf.CONSULTA_QR_CODE_CREDITO_LOJISTA.getValue();
        }
        if (op.equals(OperationEnum.OP_CRED_PARC_COM_JUROS.getDescription())) {
            return ConstantesApiCtf.CONSULTA_QR_CODE_CREDITO_ADMINISTRADORA.getValue();
        }
        if (op.equals(OperationEnum.OP_CANCELAMENTO_GENERICO.getDescription())) {
            return ConstantesApiCtf.CONSULTA_QR_CODE_CANCELAMENTO.getValue();
        }
        if (op.equals(OperationEnum.OP_DEBITO_GENERICO.getDescription())) {
            return ConstantesApiCtf.CONSULTA_QR_CODE_DEBITO.getValue();
        }
        return null;
    }

    void saveQrCodeImage(byte[] qrCodeImageBuffer) {
        try {
            IdentTerminal identTerminal = this.getIdentTerminal();
            ControladorPersistencia.getInstance().saveQrCodeImage(identTerminal, qrCodeImageBuffer);
            this.logger.info("PNG do QR Code persistido com sucesso");
        }
        catch (ExcecaoApiAc excecaoApiAc) {
            this.logger.error("Erro ao salvar QR Code: " + excecaoApiAc.getMessage());
        }
    }

    @Override
    protected String getCodigoTransacao(Process dados) {
        return ConstantesApiCtf.CONSULTA_QR_CODE.getValue();
    }
}

