/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.model.ProdutoSimulacaoCrediario;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import java.util.List;

public class MicSelecionaItemSimulacaoCrediario {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String LEGACY = "LEGACY";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR = "ERROR";

    private void exibeProdutos(LayoutDisplay display, List<ProdutoSimulacaoCrediario> produtos) {
        for (ProdutoSimulacaoCrediario produto : produtos) {
            display.addLinha(new Linha(produto.getItemDisplay()));
        }
    }

    private LayoutMenu criaMenuSimulacoes(List<ProdutoSimulacaoCrediario> produtos) {
        LayoutMenu menu = new LayoutMenu("SIMULACOES DE CREDIARIO", true);
        int indice = 1;
        for (ProdutoSimulacaoCrediario simulacao : produtos) {
            menu.addItem(new ItemMenu(simulacao.getItemDisplay(), String.valueOf(indice)));
            ++indice;
        }
        return menu;
    }

    public String execute(Process processo) throws ExcecaoNaoLocal {
        List<ProdutoSimulacaoCrediario> simulacoes = Contexto.getContexto().getSaidaApiTefC().getDadosSimulacaoCrediario();
        if (simulacoes == null || simulacoes.isEmpty()) {
            return LEGACY;
        }
        this.exibeProdutos(new LayoutDisplay(), simulacoes);
        LayoutMenu menu = this.criaMenuSimulacoes(simulacoes);
        int indiceSelecionado = processo.getPerifericos().imprimeMenu(menu);
        if (indiceSelecionado == -1) {
            return USER_CANCEL;
        }
        ProdutoSimulacaoCrediario selecionado = simulacoes.get(indiceSelecionado - 1);
        Contexto.getContexto().getEntradaApiTefC().setNumeroParcelas(selecionado.getNumParcelas());
        return SUCCESS;
    }
}

