/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.Date;

public class MicSolicitacaoCapturaCredito {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = new EntradaApiTefC();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        entrada.setOperacao(this.getCodigoTransacao(dados));
        entrada.setTimeoutCtf(Contexto.getContexto().getSaidaApiTefC().getTimeOutCTF());
        entrada.setTimestamp(new Date());
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        if (Contexto.getContexto().getSaidaApiTefC().getRetorno() == 0) {
            VerifyContentUtil.preencheDadosSaida(saidaApiTefC);
            return SUCCESS;
        }
        logger.info("Resposta autorizadora: " + saidaApiTefC.getCodigoRespostaAutorizadora());
        return ERROR;
    }

    protected String getCodigoTransacao(Process dados) throws IllegalStateException {
        String CODIGO_TRANSACAO = "GD";
        if (OperationEnum.OP_CAPTURA_CREDITO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                return CODIGO_TRANSACAO;
            }
            if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA) {
                return CODIGO_TRANSACAO;
            }
            if (Contexto.getContexto().getPlano() == Plano.LOJISTA) {
                return CODIGO_TRANSACAO;
            }
        }
        throw new IllegalStateException("C\u00f3digo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

