/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicSolicitacaoCartaoPresente
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private static final String CONSULTA_CARTAO_PRESENTE = "6B";
    private static final String RECARGA_CARTAO_PRESENTE = "E8";
    private static final String ATIVACAO_CARTAO_PRESENTE = "GC";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        if (entrada.getValorTransacao() == null && saida != null && saida.getValorTransacao() != null) {
            entrada.setValorTransacao(saida.getValorTransacao());
        }
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(ControladorCriptografia.getTabelaCriptografia());
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        if (saida != null && !saida.isReenvioNegadaHost()) {
            this.tryShowMessagePinpad(inter.getMessage("ENVIO_TITLE"));
        }
        saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            this.logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(saida);
        return SUCCESS;
    }

    protected String getCodigoTransacao(Process dados) throws IllegalStateException {
        if (OperationEnum.OP_CONSULTA_CARTAO_PRESENTE.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return CONSULTA_CARTAO_PRESENTE;
        }
        if (OperationEnum.OP_RECARGA_CARTAO_PRESENTE.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return RECARGA_CARTAO_PRESENTE;
        }
        if (OperationEnum.OP_ATIVACAO_CARTAO_PRESENTE.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return ATIVACAO_CARTAO_PRESENTE;
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

