/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import br.com.auttar.operation.util.TransactionOperationRules;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.TaxaJuroParcela;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class MicSolicitacaoConsultaFinanciamentoCredito
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        StringBuffer bit62Formatado = new StringBuffer();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        if (entrada.getDataEmissao() != null) {
            bit62Formatado.append(simpleDateFormat.format(entrada.getDataEmissao()));
            entrada.setAdicionais(bit62Formatado.toString());
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isCodigoTabelaCtrl()) {
            entrada.setCodigoTabela(Contexto.getContexto().getEntradaIntegracao().getCodigoTabela());
        } else if (conf.getCodigoTabela() > 0) {
            entrada.setCodigoTabela(conf.getCodigoTabela());
        }
        if (!conf.isIntegracaoWeb()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
            periferico.imprimeDisplay(displayModel);
        }
        if (!TransactionOperationRules.isTypedOperation() && !Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            this.tryShowMessagePinpad(inter.getMessage("ENVIO_TITLE"));
        }
        SaidaApiTefC saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            this.logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            if (saida.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERRO;
            }
            if (saida.getCodigoRespostaAutorizadora().equals("0F5")) {
                return ERRO;
            }
            return ERRO;
        }
        ArrayList<TaxaJuroParcela> parcelas = new ArrayList<TaxaJuroParcela>();
        String bit62 = saida.getAdicionais();
        this.logger.info(bit62);
        int numeroParcelaConsultada = 0;
        if (entrada.getNumeroParcelas() >= 0) {
            numeroParcelaConsultada = entrada.getNumeroParcelas();
        }
        if (numeroParcelaConsultada == 0 && bit62 != null && !bit62.trim().equals("")) {
            int qtd = 0;
            try {
                qtd = bit62.length() / 64;
            }
            catch (Exception e) {
                this.logger.error("n\u00e3o foi poss\u00edvel desmontar bit62. tamanho = " + bit62.length());
            }
            int tamanho = 64;
            int x = 0;
            for (int i = 0; i < qtd; ++i) {
                String valor = bit62.substring(tamanho * i, tamanho * i + tamanho);
                x = 0;
                TaxaJuroParcela parcela = new TaxaJuroParcela();
                parcela.setNumero(Integer.parseInt(valor.substring(x, x + 2)));
                parcela.setValor(new BigDecimal(valor.substring(x += 2, x + 12)).movePointLeft(2));
                parcela.setValorTotal(new BigDecimal(valor.substring(x += 12, x + 12)).movePointLeft(2));
                parcela.setTaxaJuros(new BigDecimal(valor.substring(x += 12, x + 7)).movePointLeft(2));
                x += 7;
                try {
                    parcela.setCodigoPlano(Integer.parseInt(valor.substring(x, x + 5)));
                }
                catch (Exception e) {
                    this.logger.debug("C\u00f3digo do plano n\u00e3o retornado: " + e.getMessage());
                }
                x += 5;
                parcelas.add(parcela);
            }
        } else {
            TaxaJuroParcela parcela = new TaxaJuroParcela();
            parcela.setNumero(numeroParcelaConsultada);
            parcela.setValor(saida.getValorParcela());
            parcela.setValorTotal(saida.getValorTotal());
            parcela.setTaxaJuros(saida.getTaxaJuros());
            parcelas.add(parcela);
        }
        Contexto.getContexto().setParcelas(parcelas);
        VerifyContentUtil.preencheDadosSaida(saida);
        return SUCESS;
    }

    protected String getCodigoTransacao(Process dado) {
        if (OperationEnum.OP_CREDITO.getDescription().equals(Contexto.getContexto().getTipoOperacao()) && Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA) {
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                return "7C";
            }
            if (Contexto.getContexto().isCartaoNaoDigitado()) {
                return "4F";
            }
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

