/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicSolicitacaoConsultaPerguntas {
    public static final String SUCCESS = "SUCCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        if (Contexto.getContexto().getSaidaApiTefC() != null && !Contexto.getContexto().getSaidaApiTefC().isConsultarPerguntas()) {
            return UNECESSARY;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENVIO1F_TITLE"));
        periferico.imprimeDisplay(displayModel);
        SaidaApiTefC saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        if (saida.getRetorno() != 0) {
            Contexto.getContexto().setSaidaApiTefC(saida);
            logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            return ERROR;
        }
        SaidaApiTefC saidaProcess = Contexto.getContexto().getSaidaApiTefC();
        saidaProcess.setInformacoesAdicionaisBuffer(saida.getInformacoesAdicionaisBuffer());
        saidaProcess.setConfirmacaoPositivaBuffer(saida.getConfirmacaoPositivaBuffer());
        saidaProcess.setVersaoConfirmacaoPositiva(saida.getVersaoConfirmarcaoPositiva());
        if (saida.getFlagBaixaTecnica() == '1' || saida.getFlagBaixaTecnica() == '2') {
            conBaixaTecnica.persisteBaixaTecnica();
        }
        VerifyContentUtil.preencheDadosSaida(saida);
        return SUCCESS;
    }

    protected String getCodigoTransacao(Process dado) throws IllegalStateException {
        if (OperationEnum.OP_FUEL_CONTROL.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "6H";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

