/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicSolicitacaoCrediario {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERRO_REJEITADO_AUTORIZADORA = "ERRO_REJEITADO_AUTORIZADORA";
    public static final String ERRO_NAO_AUT_CARTAO = "ERRO_NAO_AUT_CARTAO";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(ControladorCriptografia.getTabelaCriptografia());
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("SOLCONCDC_SOLICITACAO"));
            periferico.imprimeDisplay(displayModel);
        }
        SaidaApiTefC saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            Contexto.getContexto().setSaidaApiTefC(saida);
            if (saida.getRetorno() != 0) {
                if (saida.getCodigoRespostaAutorizadora().equals("0F5")) {
                    return ERRO_NAO_AUT_CARTAO;
                }
                return ERRO;
            }
            VerifyContentUtil.preencheDadosSaida(saida);
            if (saida.getFlagBaixaTecnica() == '1' || saida.getFlagBaixaTecnica() == '2') {
                conBaixaTecnica.persisteBaixaTecnica();
            }
            return SUCESS;
        }
        return SUCESS;
    }

    protected String getCodigoTransacao(Process dado) throws IllegalStateException {
        if (OperationEnum.OP_CREDIARIO_DE_DEBITO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "GB";
        }
        if (OperationEnum.OP_CREDIARIO_DE_CREDITO.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_CREDITO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "1S";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

