/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.DadosTelefone;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicSolicitacaoCreditoCelular {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        DadosTelefone creditoDigital = new DadosTelefone();
        if (entrada.getCodigoAutorizadora() != null) {
            String operadoraTelefonia = entrada.getCodigoAutorizadora();
            creditoDigital.setCodigoAutorizadora(operadoraTelefonia);
        }
        creditoDigital.setDdd(entrada.getDdd());
        creditoDigital.setTelefone(entrada.getTelefone());
        if (entrada.isCapturaDigito()) {
            creditoDigital.setDigitoVerificadortelefone(entrada.getDigitoVerificadortelefone());
        }
        creditoDigital.setCodigoUsuarioPdv(entrada.getCodigoUsuarioPdv());
        creditoDigital.setTipoCreditoCompra(entrada.getTipoCreditoCompra());
        creditoDigital.setVersaoLayout(conf.getVersaoLayoutCD());
        entrada.setDadosCreditoDigital(creditoDigital);
        entrada.setOperacao(this.getCodigoTransacao(dados));
        try {
            SaidaGetInfoEMV getInfo = periferico.getPin().getInfo();
            entrada.setNumeroSeriePin(getInfo.getNumSeriePinpad());
            entrada.setRetornoGetInfo(getInfo.getRetorno());
            entrada.setTipoPin("16");
        }
        catch (Exception e) {
            logger.warn("Nao foi possivel ler as informacoes do pin: " + e.getMessage());
            entrada.setTipoPin("**");
        }
        if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
            entrada.setNumeroParcelas(1);
        } else if (entrada.getNumeroParcelas() < 0) {
            entrada.setNumeroParcelas(0);
        }
        entrada.setTimeoutCtf(200);
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        SaidaApiTefC saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        saida.setDDD(entrada.getDdd());
        saida.setTelefone(entrada.getTelefone());
        if (saida.getRetorno() != 0) {
            logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(saida);
        return SUCESS;
    }

    private String getCodigoTransacao(Process dados) {
        if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
            return "4J";
        }
        if (Contexto.getContexto().getPlano() == Plano.LOJISTA) {
            return "4K";
        }
        if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA) {
            return "4L";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

