/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.DateUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class MicSolicitacaoDebito
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERRO_REJEITADO_AUTORIZADORA = "ERRO_REJEITADO_AUTORIZADORA";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    public static final String ERRO_NAO_AUT_CARTAO = "ERRO_NAO_AUT_CARTAO";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.getTipoProduto() != null) {
            entrada.setTipoProduto(entradaIntegracao.getTipoProduto());
        }
        entrada.setOperacao(this.getCodigoTransacao(dados));
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(ControladorCriptografia.getTabelaCriptografia());
        if (Contexto.getContexto().getPlano() == Plano.PARCELADO) {
            int numeroParcelas = entrada.getNumeroParcelas();
            BigDecimal valorTransacao = entrada.getValorTransacao();
            BigDecimal valorParcela = valorTransacao.divide(new BigDecimal(numeroParcelas), 2, 6);
            BigDecimal totalTruncado = valorParcela.multiply(new BigDecimal(numeroParcelas));
            BigDecimal valor1Parcela = valorParcela.add(valorTransacao.subtract(totalTruncado));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            StringBuffer bit62Formatado = new StringBuffer();
            if (entrada.getDataVencimento() != null) {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.setTime(entrada.getDataVencimento());
                String dataFormatada = simpleDateFormat.format(calendar.getTime());
                String valorFormatado = valor1Parcela.movePointRight(2).toString();
                bit62Formatado.append(StringUtil.completaString(valorFormatado + dataFormatada, 20, '0', 3));
                for (int i = 0; i < numeroParcelas - 1; ++i) {
                    calendar.add(5, 30);
                    dataFormatada = simpleDateFormat.format(calendar.getTime());
                    valorFormatado = valorParcela.movePointRight(2).toString();
                    bit62Formatado.append(StringUtil.completaString(valorFormatado + dataFormatada, 20, '0', 3));
                }
                entrada.setAdicionais(bit62Formatado.toString());
            }
        } else if (Contexto.getContexto().getPlano() == Plano.PREDATADO) {
            if (entrada.getDataVencimentoDebito() != null) {
                String dataFormatada = new SimpleDateFormat("yyyyMMdd").format(entrada.getDataVencimentoDebito());
                String valorFormatado = entrada.getValorTransacao().movePointRight(2).toString();
                String bit62Formatado = StringUtil.completaString(valorFormatado + dataFormatada, 20, '0', 3);
                entrada.setAdicionais(bit62Formatado);
            }
        } else if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
            entrada.setNumeroParcelas(1);
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        entrada.setAcSuportaPlataformaPromocional(conf.isAcSuportaPlataformaPromocional());
        entrada.setClientSuportaPlataformaPromocional(true);
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
            displayModel.setImagem(LayoutDisplay.imagens.aguarde_autorizacao);
            periferico.imprimeDisplay(displayModel);
        }
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            this.tryShowMessagePinpad(inter.getMessage("ENVIO_TITLE"));
        }
        saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            Contexto.getContexto().setSaidaApiTefC(saida);
            if (saida.getRetorno() != 0) {
                this.logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
                if (saida.getCodigoRespostaAutorizadora().equals("0ER")) {
                    return ERRO_TRANS_JA_EFETUADA;
                }
                if (saida.getCodigoRespostaAutorizadora().equals("0F5")) {
                    return ERRO_NAO_AUT_CARTAO;
                }
                return ERRO;
            }
            VerifyContentUtil.preencheDadosSaida(saida);
            return SUCESS;
        }
        return SUCESS;
    }

    protected String getCodigoTransacao(Process dado) throws IllegalStateException {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (OperationEnum.OP_DEBITO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                return "10";
            }
            if (Contexto.getContexto().getPlano() == Plano.CDC) {
                Date now = dado.getStartProcess();
                if (DateUtil.equalsData(entradaApiTefC.getDataVencimento(), now)) {
                    return "5A";
                }
                return "5B";
            }
            if (Contexto.getContexto().getPlano() == Plano.PARCELADO) {
                Date now = dado.getStartProcess();
                if (DateUtil.equalsData(entradaApiTefC.getDataVencimento(), now)) {
                    return "28";
                }
                return "23";
            }
            if (Contexto.getContexto().getPlano() == Plano.PREDATADO) {
                return "20";
            }
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

