/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.ResumoEstatistica;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.ControladorEstatistica;
import com.csi.ctfclient.operacoes.model.DadosEstatistica;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoRedecardEMV;
import com.csi.ctfclient.tools.util.VerifyContentUtil;

public class MicSolicitacaoEstatistica {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR_CTF = "ERROR_CTF";
    public static final String ERROR = "ERROR";
    private static final String OPERACAO = "2O";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) {
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        EntradaApiTefC entrada = new EntradaApiTefC();
        ControladorPerifericos perifericos = dados.getPerifericos();
        try {
            boolean connectedPin;
            entrada.setOperacao(OPERACAO);
            ControladorEstatistica controladorEstatistica = ControladorEstatistica.getInstance();
            DadosEstatistica dadosEstatistica = controladorEstatistica.getDadosEstatistica();
            ResumoEstatistica resumoEstatistica = new ResumoEstatistica();
            boolean bl = connectedPin = perifericos.getPin() != null;
            if (connectedPin) {
                SaidaGetInfoEMV pinInfo = perifericos.getPin().getInfo();
                if (pinInfo != null) {
                    resumoEstatistica.setFabricantePinpad(pinInfo.getFabricante());
                    resumoEstatistica.setNumeroSeriePinpad(pinInfo.getNumSeriePinpad());
                    resumoEstatistica.setVersaoHardwarePinpad(pinInfo.getModeloHardware());
                    resumoEstatistica.setVersaoEspecificacao(pinInfo.getVersaoEspecificacao());
                    resumoEstatistica.setVersaoFirmwarePinpad(pinInfo.getVersaoFirmware());
                    resumoEstatistica.setVersaoAplBasica(pinInfo.getVersaoAplBasica());
                    SaidaGetInfoRedecardEMV infoRedecardEMV = perifericos.getPin().getInfoRedecard();
                    entrada.setVersaoBibliotecaCompartilhada(infoRedecardEMV.getInformacaoProprietaria());
                    resumoEstatistica.setVersaoKernelEMV(infoRedecardEMV.getVersaoKernelEMV());
                    entrada.setNumeroSeriePin(pinInfo.getNumSeriePinpad());
                    entrada.setRetornoGetInfo(pinInfo.getRetorno());
                }
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("**");
            }
            resumoEstatistica.setNomeFabricanteTef("AUTTAR PROCESSAMENTO DE DADOS");
            resumoEstatistica.setVersaoAplTef(ControladorConfCTFClient.VERSAO_CLIENT);
            if (entradaIntegracao != null) {
                resumoEstatistica.setNomeFabricanteAc(entradaIntegracao.getNomeAc());
                resumoEstatistica.setVersaoAplAc(entradaIntegracao.getVersaoAc());
            }
            resumoEstatistica.setQtdeLeituraMagnetico(dadosEstatistica.getQtdeLeituraMagnetico());
            resumoEstatistica.setQtdeErroLeituraMagnetico(dadosEstatistica.getQtdeErroLeituraMagnetico());
            resumoEstatistica.setQtdeSenhaPinMagnetico(dadosEstatistica.getQtdeSenhaPinMagnetico());
            resumoEstatistica.setQtdeErroSenhaPinMagnetico(dadosEstatistica.getQtdeErroSenhaPinMagnetico());
            resumoEstatistica.setQtdeSenhaOnlineChip(dadosEstatistica.getQtdeSenhaOnlineChip());
            resumoEstatistica.setQtdeErroSenhaOnlineChip(dadosEstatistica.getQtdeErroSenhaOnlineChip());
            resumoEstatistica.setQtdeSenhaOfflineChip(dadosEstatistica.getQtdeSenhaOfflineChip());
            resumoEstatistica.setQtdeErroSenhaOfflineChip(dadosEstatistica.getQtdeErroSenhaOfflineChip());
            resumoEstatistica.setQtdeCartoesBloqErroSenhaChip(dadosEstatistica.getQtdeCartoesBloqErroSenhaChip());
            resumoEstatistica.setQtdeLeituraSmart(dadosEstatistica.getQtdeLeituraSmart());
            resumoEstatistica.setQtdeFallbackChipCredito(dadosEstatistica.getQtdeFallbackChipCredito());
            resumoEstatistica.setQtdeFallbackChipDebito(dadosEstatistica.getQtdeFallbackChipDebito());
            entrada.setEstatistica(resumoEstatistica);
            if (Contexto.getContexto().getSaidaApiTefC() != null) {
                entrada.setTimeoutCtf(Contexto.getContexto().getSaidaApiTefC().getTimeOutCTF());
            } else {
                entrada.setTimeoutCtf(30);
            }
            entrada.setDataCliente(dados.getStartProcess());
            SaidaApiTefC saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
            if (Contexto.getContexto().getTipoOperacao() != null && Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_ESTATISTICA_MANUAL.getDescription())) {
                Contexto.getContexto().setSaidaApiTefC(saida);
            }
            if (saida.getRetorno() != 0) {
                logger.info("nao foi possivel enviar a transa\u00e7\u00e3o de estat\u00edstica: ");
                logger.info("codigo retorno = " + saida.getRetorno() + " erro = " + saida.getCodigoErro());
                return ERROR;
            }
            VerifyContentUtil.preencheDadosSaida(saida);
        }
        catch (ExcecaoApiAc e) {
            logger.error("Erro ao solicitar a transa\u00e7\u00e3o de estat\u00edstica: " + e.getMessage());
            return ERROR;
        }
        return SUCESS;
    }
}

