/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicSolicitacaoFuelControl {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERRO_REJEITADO_AUTORIZADORA = "ERRO_REJEITADO_AUTORIZADORA";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    public static final String ERRO_NAO_AUT_CARTAO = "ERRO_NAO_AUT_CARTAO";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(ControladorCriptografia.getTabelaCriptografia());
        if (entradaIntegracao != null && entradaIntegracao.isPermiteAprovacaoValorParcialCtrl()) {
            logger.info("Permite aprova\u00e7\u00e3o parcial do valor (AC): " + entradaIntegracao.isPermiteAprovacaoValorParcial());
            entrada.setPermiteAprovacaoValorParcial(entradaIntegracao.isPermiteAprovacaoValorParcial());
        }
        LayoutDisplay layoutDisplay = new LayoutDisplay();
        layoutDisplay.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        layoutDisplay.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        layoutDisplay.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(layoutDisplay);
        SaidaApiTefC saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            if (saida.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERRO_TRANS_JA_EFETUADA;
            }
            if (saida.getCodigoRespostaAutorizadora().equals("0F5")) {
                return ERRO_NAO_AUT_CARTAO;
            }
            return ERRO;
        }
        if (saida.getFlagBaixaTecnica() == '1' || saida.getFlagBaixaTecnica() == '2') {
            conBaixaTecnica.persisteBaixaTecnica();
        }
        VerifyContentUtil.preencheDadosSaida(saida);
        return SUCESS;
    }

    protected String getCodigoTransacao(Process dado) throws IllegalStateException {
        if (OperationEnum.OP_FUEL_CONTROL.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "6G";
        }
        if (OperationEnum.OP_RESERVA_FUEL_CONTROL.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "6Z";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

