/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicSolicitacaoSaqueTransferenciaDomestica {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        ControladorPerifericos periferico = dados.getPerifericos();
        String codigoTransacao = this.getCodigoTransacao(dados);
        entrada.setOperacao(codigoTransacao);
        entrada.setTimeoutCtf(60);
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        IdentApiTefC ident = Contexto.getContexto().getIdentApiTefC();
        SaidaApiTefC saida = dados.getApitef().solicitacao(ident, entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(saida);
        return SUCCESS;
    }

    protected String getCodigoTransacao(Process dados) {
        return "G9";
    }
}

